block('b-private-deals-value')(

    content()(function() {
        return u.numberFormatter.format(this.ctx.value || 0, { precision: 0 })
    }),

    mod('type', 'percentage')(

        content()(function() {
            return u.numberFormatter.format(this.ctx.value || 0, { precision: 2 })
        }),

        attrs()(function() {
            return { unit: '%' };
        })
    ),

    mod('type', 'price')(
        attrs()(function() {
            var currencyCode = this.ctx.currency,
                currencySign = u._.get(u.currencies.get(currencyCode), 'currency_sign');

            return { unit: currencySign };
        }),

        content()(function() {
            var floatDelimiter = '__',
                valueFormatted = u.numberFormatter.format(
                    this.ctx.value || 0,
                    { precision: 2, floatDelimiter: floatDelimiter }
                ),
                valueSplitted = valueFormatted.split(floatDelimiter);

            return [
                valueSplitted[0],
                {
                    elem: 'coins',
                    tag: 'span',
                    content: [
                        ',',
                        valueSplitted[1]
                    ]
                }
            ];
        })
    )

);
