BEM.DOM.decl('b-private-deals', {

    onSetMod: {
        js: function() {
            this._history = BEM.blocks.history.getInstance();
            this._location = BEM.blocks.location.getInstance();
            this._noStat = this.params.noStat;

            this._history.on('statechange', this._onStateChange, this);

            this._onStateChange();
        }
    },

    /**
     * Построение таблицы сделок
     * @param {String} [field] поле по которому необходимо отсортировать список
     * @param {String} [reverse] порядок сортировки
     * @private
     */
    _buildDealsList: function(field, reverse) {
        return BEM.blocks['i-web-api-request'].privateDeals.getDealsList(u.consts('ulogin'), field, reverse, this._noStat)
            .then(function(resp) {
                if ((resp.result || []).length) {
                    BEM.DOM.update(this.findElem('deals-list'), BEMHTML.apply({
                        block: 'b-private-deals-table',
                        deals: resp.result
                    }));

                    this._dealsTable = this.findBlockInside('b-private-deals-table');
                } else {
                    BEM.DOM.update(this.findElem('deals-list'), BEMHTML.apply({
                        block: 'b-private-deals',
                        elem: 'empty'
                    }));
                }
            }.bind(this))
            .catch(this._loadDealsFailed.bind(this));
    },

    /**
     * Обновление данных одной сделки
     * @param {Number} dealId id сделки
     * @private
     */
    _updateDeal: function(dealId) {
        BEM.blocks['i-web-api-request'].privateDeals.getDealsList(u.consts('ulogin'), null, null, this._noStat)
            .then(function(resp) {
                return u._.find(resp.result, { id: dealId })
            })
            .then(function(deal) {
                this._dealsTable.updateDeal(dealId, deal);
                this._dealsTable.dropSortStates();
                this._sortDropped = true;
            }.bind(this))
            .catch(this._loadDealsFailed.bind(this));
    },

    /**
     * Обновление данных списка сделок
     * @param {String} field поле по которому необходимо отсортировать список
     * @param {String} reverse порядок сортировки
     * @private
     */
    _updateDeals: function(field, reverse) {
        return BEM.blocks['i-web-api-request'].privateDeals.getDealsList(u.consts('ulogin'), field, reverse, this._noStat)
            .then(function(resp) {
                this._dealsTable.updateDeals(resp.result);
            }.bind(this))
            .catch(this._loadDealsFailed.bind(this));
    },

    /**
     * Отображение сообщения при ошибке в запросе данных
     * @private
     */
    _loadDealsFailed: function() {
        BEM.DOM.update(this.findElem('deals-list'), BEMHTML.apply({
            block: 'b-private-deals',
            elemMods: { type: 'load-error' },
            elem: 'empty'
        }));
    },

    /**
     * Включение подсветки строки в таблице, используется для выделения строки при открытии инспектора
     * @param {Number} id сделки
     * @private
     */
    _setDealHighlight: function(id) {
        this._dealsTable.setDealHighlight(id);
    },

    /**
     * Отключени подсветки строки в таблице, используется для выделения строки при открытии инспектора
     * @private
     */
    _dropDealHighlight: function() {
        this._dealsTable.dropDealHighlight();
    },

    /**
     * Открываем инспектор по id сделки
     * @param {Number} id
     * @private
     */
    _showInspector: function(id) {
        this.blockInside('b-private-deals-inspector').show(id);
    },

    /**
     * Флаг о сброшенной сортировке
     */
    _sortDropped: false,

    /**
     * Обновляем url/состояние (HTML5 History API) в соответствии с переданными параметрами сортировки
     * @param {String} field поле по которому будет идти сортировка
     * @private
     */
    _pushState: function(field) {
        var url = this._location.getUri(),
            state = u.parseUrl(url.toString()).query,
            currField = state.sort_by,
            numericFields = [
                'spent',
                'shows',
                'min_price',
                'cpm',
                'clicks',
                'cpc',
                'ctr',
                'id'
            ],
            reverse = state.sort_order;

        if (currField && currField === field && !this._sortDropped) {
            if (reverse) {
                reverse = reverse === 'desc' ? 'asc' : 'desc';
            } else {
                reverse = 'desc';
            }

            url.replaceParam('sort_order', reverse);
        } else {
            // У "числовых" полей по умолчанию другой порядок сортировки
            u._.contains(numericFields, field) ?
                url.replaceParam('sort_order', 'desc') :
                url.deleteParam('sort_order');

            url.replaceParam('sort_by', field);
            this._sortDropped = false;
        }

        this._history.pushState(undefined, document.title, url.toString());
    },

    /**
     * Обработчик изменения url/состояния (HTML5 History API)
     * @param {Event} e
     * @param {Object} data данные текущего состояния
     * @private
     */
    _onStateChange: function(e, data) {
        var state = u.parseUrl(u._.get(data, 'url') || u._.get(data, 'state.url') || this._location.getUri().toString()).query,
            reverse = state.sort_order,
            field = state.sort_by,
            infoFields = [
                'deal_type',
                'name',
                'status'
            ],
            numericFields = [
                'spent',
                'shows',
                'min_price',
                'cpm',
                'clicks',
                'cpc',
                'ctr',
                'id'
            ],
            availableFieldsToSort = infoFields.concat(numericFields);

        if (!field && !reverse) {
            this._buildDealsList();
        } else if (u._.contains(numericFields, field) && !reverse) {
            // У "числовых" полей по умолчанию другой порядок сортировки
            this._pushState(field);
        } else if (u._.contains(availableFieldsToSort, field)) {
            if (this._dealsTable) {
                this._dealsTable.lockBody();
                this._dealsTable.setSortStates(field, reverse);
                this._updateDeals(field, reverse);
            } else {
                this._buildDealsList(field, reverse).then(function() {
                    this._dealsTable.setSortStates(field, reverse);
                }.bind(this));
            }
        } else {
            this._pushState('id');
        }
    },

    /**
     * Обработчик изменения данных в сделке
     * @param {Event} e
     * @param {Object} data
     * @private
     */
    _onDealChange: function(e, data) {
        this._updateDeal(data.id);
    },

    /**
     * Обработчик открытия инспектора с конкретной сделкой
     * @param {Event} e
     * @param {Object} data
     * @private
     */
    _onDealShow: function(e, data) {
        this._setDealHighlight(data.id);
    },

    /**
     * Обработчик закрытия инспектора
     * @param {Event} e
     * @param {Object} data
     * @private
     */
    _onDealHide: function(e, data) {
        this._dropDealHighlight();
    },

    /**
     * Обработчик выбора сделки в списке
     * @param {Event} e
     * @param {Object} data
     * @private
     */
    _onDealSelect: function(e, data) {
        this._showInspector(data.id);
    },

    /**
     * Обработчик сортировки списка сделок
     * @param {Event} e
     * @param {Object} data
     * @private
     */
    _onDealsSort: function(e, data) {
        this._pushState(data.field);
    }

}, {
    live: function() {
        this
            .liveInitOnBlockInsideEvent('deal-change', 'b-private-deals-inspector', function(e, data) {
                this._onDealChange(e, data);
            })
            .liveInitOnBlockInsideEvent('deal-show', 'b-private-deals-inspector', function(e, data) {
                this._onDealShow(e, data);
            })
            .liveInitOnBlockInsideEvent('deal-hide', 'b-private-deals-inspector', function(e, data) {
                this._onDealHide(e, data);
            })
            .liveInitOnBlockInsideEvent('deal-selected', 'b-private-deals-table', function(e, data) {
                this._onDealSelect(e, data);
            })
            .liveInitOnBlockInsideEvent('deals-sort', 'b-private-deals-table', function(e, data) {
                this._onDealsSort(e, data);
            });

        return false;
    }
});
