block('b-promo-slider').content()(function() {
    var sliderContent = this.ctx.slides.reduce(function(result, item) {
        result.images.push({
            elem: 'image',
            attrs: {
                src: item.src
            }
        });

        result.info.push({
            elem: 'item',
            content: [
                {
                    elem: 'title',
                    content: item.title
                },
                {
                    elem: 'text',
                    content: item.text
                }
            ]
        });

        result.pager.push({
            elem: 'pager-item',
            elemMods: {
                current: item.current ? 'yes' : undefined
            }
        });

        return result;

    }, {
        images: [],
        info: [],
        pager: []
    });

    return [
        {
            elem: 'nav'
        },
        {
            elem: 'images',
            content: {
                elem: 'items',
                content: sliderContent.images
            }
        },
        {
            elem: 'info',
            content: {
                elem: 'items',
                content: sliderContent.info
            }
        },
        {
            elem: 'pager',
            content: sliderContent.pager
        }
    ];
});
