BEM.DOM.decl('b-promo-slider', {

    onSetMod: {

        js: function() {
            this
                ._repeatAnimation()
                .bindTo('pager-item arrow', 'click', function(e) {
                    this._navigationClick(e.data.domElem);
                });
        }

    },

    /**
     * Повторяет анимацию
     * @private
     */
    _repeatAnimation: function() {
        this._timeout = setTimeout(function() {
            this._animate(this._calculateIndex('next'));
        }.bind(this), 5000);

        return this;
    },

    /**
     * Останавливает анимацию
     * @private
     */
    _stopAnimation: function() {
        clearTimeout(this._timeout);
    },

    /**
     * Индекс последнего слайда
     * @private
     */
    _lastItemIndex: null,

    /**
     * Возвращает индекс последнего слайда
     * @returns {Number}
     * @private
     */
    _getLastItemIndex: function() {
        return this._lastItemIndex || (this._lastItemIndex = this.elem('pager-item').length - 1);
    },

    /**
     * Высчитывает индекс слайда для анимации
     * @param {String} action — направление анимации [next, prev]
     * @returns {Number}
     * @private
     */
    _calculateIndex: function(action) {
        var lastItemIndex = this._getLastItemIndex(),
            currentIndex = this.elem('pager-item', 'current', 'yes').index();

        switch (action) {
            case 'prev':
                return currentIndex === 0 ? lastItemIndex : currentIndex - 1;
            case 'next':
                return lastItemIndex === currentIndex ? 0 : currentIndex + 1;
        }

    },

    /**
     * Обработчик события click по элементам навигации — [arrow, pager-item]
     * @param {jQuery} target — DOM-элемент по которому произошел click
     * @private
     */
    _navigationClick: function(target) {
        var action = this.getMod(target, 'type'),
            index = action ? this._calculateIndex(action) : target.index();

        this._animate(index, true);
    },

    /**
     * Анимация слайдера
     * @param {Number} index — индекс слайда
     * @param {Boolean} [stop] — параметр для остановки анимации
     * @private
     */
    _animate: function(index, stop) {
        var iUa = BEM.blocks['i-ua'];

        iUa.check('transform') && iUa.check('transition') ?
            this.elem('items').css(iUa.check('transform'), 'translate3d(-' + index * 10 + '%, 0, 0)') :
            this.elem('items').animate({ left: '-' + index * 100 + '%' });

        this
            .delMod(this.elem('pager-item'), 'current')
            .setMod(this.elem('pager-item').eq(index), 'current', 'yes');

        this[stop ? '_stopAnimation' : '_repeatAnimation']();
    }

});
