# b-promo

## Описание
Блок для размещения информации о продвижении новых фич.

#### Доступные модификаторы: 
- ```type: 'action'``` - добавляет к промоблоку кнопку-ссылку с призывом к действию

#### Интерфейс блока:
- ```content``` - текст, описывающий фичу
- ```imgUrl``` - ссылка на картинку, которая иллюстрирует фичу
- ```imgAltText``` - альтернативный текст картинки

##### Только для ``` type: 'action' ```
- ```buttonName``` - текст кнопки
- ```buttonLinkUrl``` - ссылка, на которую ведет кнопка

### Автор
[Dmitry Volovod](https://staff.yandex-team.ru/dimazoll)

##Примеры

```
// Вариант блока без кнопки
{
    block: 'b-promo',
    imgUrl: imgUrl,
    imgAltText: 'Турбо-страница с ускоренной загрузкой',
    content: 'Теперь вы можете использовать Турбо-страницу, не указывая ссылку на сайт.'
}

// Вариант блока с кнопкой призыва к действию
{
    block: 'b-promo',
    mods: {
        type: 'action'
    },
    buttonName: 'Попробовать',
    buttonLinkUrl: 'https://yandex.ru',
    imgUrl: imgUrl,
    imgAltText: 'Турбо-страница с ускоренной загрузкой',
    content: 'Контакты в объявлении: теперь вы можете использовать Турбо-страницу, не указывая ссылку на сайт.'
}
```
