block('b-quality-verdicts-list')(
    def()(function() {
        return applyNext({
            expandButtonTexts: this.ctx.expandButtonTexts || {
                expand: iget2('b-quality-verdicts-list', 'razvernut-vse-rekomendacii', 'Развернуть все рекомендации'),
                fold: iget2('b-quality-verdicts-list', 'svernut-vse-rekomendacii', 'Свернуть все рекомендации')
            },
        });
    }),

    js()(function() {
        return {
            expandButtonTexts: this.expandButtonTexts,
        };
    }),

    content()(function() {
        var verdictsCount = 0, // @tgnc: итоговое количество причин
            shouldVerdictsBeExpanded = '', // @tgnc: должны ли причины быть сразу развернутыми при открытии попапа
            verdicts = [], // @tgnc: сами причины
            verdictsByOperators, // @tgnc: причины операторов, сгруппированные по операторам
            supportLink = {
                block: 'link',
                target: 'blank',
                mods: {
                    theme: 'without-border'
                },
                content: iget2('b-quality-verdicts-list', 'support', 'службу поддержки'),
                url: u.getCommonHelpUrl('/direct/contact-us.html')
            },
            operatorRequirements = {
                block: 'link',
                target: 'blank',
                mods: {
                    theme: 'without-border'
                },
                content: iget2('b-quality-verdicts-list', 'meets-the-requirements', 'соответствует требованиям'),
                url: u.getCommonHelpUrl('/direct/products-cpm-campaign-outdoor/requirements.html')
            },
            moderationRejectReasons = this.ctx.moderationRejectReasons || {},
            operatorsRejectReasons = this.ctx.operatorsRejectReasons || {},
            shouldOperatorReasonsBeExpanded = 'yes',
            shouldOperatorReasonsBeExpandable = 'no';

        // Если причин операторов больше 1, то все причины у всех операторов должны быть схлопнуты.
        if (
            Object.keys(operatorsRejectReasons).length > 1 ||
            Object.keys(operatorsRejectReasons).some(function(operator) {
                var err = operatorsRejectReasons[operator].errors ? 1 : 0;
                return operatorsRejectReasons[operator].reasons.length + err > 1
            })
        ) {
            shouldOperatorReasonsBeExpanded = '';
            shouldOperatorReasonsBeExpandable = ''
        }

        if (moderationRejectReasons && moderationRejectReasons.reasons) {
            verdictsCount += moderationRejectReasons.reasons.length
        }

        if (this.ctx.verdicts) {
            verdictsCount += this.ctx.verdicts.length
        }

        if (moderationRejectReasons && moderationRejectReasons.hasErrors) {
            verdictsCount += 1 // @tgnc: потому что ошибки не массив, а Boolean
        }

        if (verdictsCount === 1) {
            shouldVerdictsBeExpanded = 'yes'
        }

        verdictsByOperators = Object.keys(operatorsRejectReasons)
            .map(function(operator) {
                var comment = operatorsRejectReasons[operator].comment;

                return (operatorsRejectReasons[operator].reasons.length ||
                    operatorsRejectReasons[operator].hasErrors) &&
                    {
                        elem: 'operator-verdicts',
                        tag: 'li',
                        content: [
                            {
                                elem: 'operator-name',
                                tag: 'p',
                                content: operator.split(': ')[1] || operator
                            },
                            (comment && comment.trim()) && {
                                elem: 'comment',
                                content: [
                                    {
                                        elem: 'comment-title',
                                        content: iget2('b-quality-verdicts-list', 'operator-comment', 'Комментарий от оператора')
                                    },
                                    u.escapeHTML(comment)
                                ]
                            },
                            {
                                elem: 'operator-verdicts',
                                elemMods: {
                                    'by-operator': true
                                },
                                tag: 'ul',
                                content: operatorsRejectReasons[operator].reasons.map(function(reason) {
                                    return reason && {
                                        elem: 'verdict',
                                        elemMods: {
                                            expanded: shouldOperatorReasonsBeExpanded,
                                            expandable: shouldOperatorReasonsBeExpandable,
                                            'without-title': reason.title ? '' : 'yes'
                                        },
                                        tag: 'li',
                                        content: [
                                            {
                                                block: 'link',
                                                mods: {
                                                    pseudo: 'yes',
                                                    theme: 'without-border'
                                                },
                                                mix: [
                                                    {
                                                        block: 'b-quality-verdicts-list',
                                                        elem: 'verdict-title',
                                                    }, {
                                                        block: 'b-metrika',
                                                        js: {
                                                            goals: [
                                                                'SHOWTEXT', {
                                                                    name: 'SHOWTEXT',
                                                                    counter: '34'
                                                                }
                                                            ]
                                                        }
                                                    }
                                                ],
                                                content: reason.title,
                                            },
                                            {
                                                elem: 'verdict-recommendation',
                                                elemMods: {
                                                    outdoor: true
                                                },
                                                content: reason.content
                                            }
                                        ]
                                    }
                                }, this).concat([operatorsRejectReasons[operator].hasErrors && {
                                    elem: 'verdict',
                                    elemMods: {
                                        expanded: shouldOperatorReasonsBeExpanded,
                                        expandable: shouldOperatorReasonsBeExpandable,
                                        'without-title': ''
                                    },
                                    tag: 'li',
                                    content: [
                                        {
                                            block: 'link',
                                            mods: {
                                                pseudo: 'yes',
                                                theme: 'without-border'
                                            },
                                            mix: [
                                                {
                                                    block: 'b-quality-verdicts-list',
                                                    elem: 'verdict-title',
                                                }, {
                                                    block: 'b-metrika',
                                                    js: {
                                                        goals: [
                                                            'SHOWTEXT', {
                                                                name: 'SHOWTEXT',
                                                                counter: '34'
                                                            }
                                                        ]
                                                    }
                                                }
                                            ],
                                            content: iget2('b-quality-verdicts-list', 'operator-common-reason-header', 'Объявление не соответствует требованиям оператора'),
                                        },
                                        {
                                            elem: 'verdict-recommendation',
                                            content: [
                                                {
                                                    tag: 'p',
                                                    content: iget2(
                                                        'b-quality-verdicts-list',
                                                        'operator-common-reason-content',
                                                        'Убедитесь, что реклама ваших товаров и услуг разрешена законодательством и рекламной политикой Яндекса. Проверьте, что объявление {requirements} и вы предоставили все необходимые документы.',
                                                        {
                                                            requirements: operatorRequirements
                                                        }
                                                    )
                                                },
                                                {
                                                    tag: 'p',
                                                    content: iget2(
                                                        'b-quality-verdicts-list',
                                                        'operator-common-reason-content-addition',
                                                        'За дополнительной информацией можете обратиться в {link}.',
                                                        {
                                                            link: supportLink
                                                        }
                                                    )
                                                }
                                            ]
                                        }
                                    ]
                                }])
                            }
                        ]
                    }
            }, this);

        verdicts = this.ctx.verdicts.map(function(verdict) {
            if (this.ctx.verdicts[0].type === 'old' && moderationRejectReasons) {
                return
            }
            return verdict && {
                elem: 'verdict',
                elemMods: {
                    expanded: shouldVerdictsBeExpanded,
                    expandable: verdictsCount === 1 ? 'no' : '',
                    'without-title': verdict.title ? '' : 'yes'
                },
                tag: 'li',
                content: [
                    verdictsCount === 1 ?
                        {
                            block: 'b-quality-verdicts-list',
                            elem: 'verdict-title',
                            content: verdict.title
                        } :
                        {
                            block: 'link',
                            mods: {
                                pseudo: 'yes',
                                theme: 'without-border'
                            },
                            mix: [
                                {
                                    block: 'b-quality-verdicts-list',
                                    elem: 'verdict-title'
                                }, {
                                    block: 'b-metrika',
                                    js: {
                                        goals: [
                                            'SHOWTEXT', {
                                                name: 'SHOWTEXT',
                                                counter: '34'
                                            }
                                        ]
                                    }
                                }
                            ],
                            content: verdict.title
                        },
                    {
                        elem: 'verdict-recommendation',
                        content: verdict.recommendation
                    }
                ]
            };
        }, this);

        if (moderationRejectReasons && moderationRejectReasons.hasErrors) {
            verdicts.push(
                {
                    elem: 'verdict',
                    elemMods: {
                        expanded: shouldVerdictsBeExpanded,
                        expandable: verdictsCount === 1 ? 'no' : '',
                    },
                    tag: 'li',
                    content: [
                        {
                            block: 'link',
                            mods: {
                                pseudo: 'yes',
                                theme: 'without-border'
                            },
                            mix: [
                                {
                                    block: 'b-quality-verdicts-list',
                                    elem: 'verdict-title',
                                }, {
                                    block: 'b-metrika',
                                    js: {
                                        goals: [
                                            'SHOWTEXT', {
                                                name: 'SHOWTEXT',
                                                counter: '34'
                                            }
                                        ]
                                    }
                                }
                            ],
                            content: iget2('b-quality-verdicts-list', 'outdoor-common-reason-header', 'Объявление не соответствует требованиям'),
                        },
                        {
                            elem: 'verdict-recommendation',
                            elemMods: {
                                outdoor: true,
                                id: 'outdoor-common-reason',
                            },
                            content: [
                                {
                                    elem: 'verdict-recommendation',
                                    content: iget2(
                                        'b-quality-verdicts-list',
                                        'outdoor-common-reason-text',
                                        'Убедитесь, что реклама ваших товаров и услуг допускается действующим законодательством и рекламной политикой Яндекса.'
                                    ),
                                },
                                {
                                    block: 'link',
                                    target: 'blank',
                                    mods: {
                                        theme: 'without-border'
                                    },
                                    content: iget2('b-quality-verdicts-list', 'full-rules-list', 'Полный список требований'),
                                    url: u.getLegalHelpUrl('/general_adv_rules/')
                                }
                            ]
                        }
                    ]
                }
            );
        }

        if (
            moderationRejectReasons &&
            moderationRejectReasons.reasons &&
            !!moderationRejectReasons.reasons.length
        ) {
            (moderationRejectReasons.reasons || []).forEach(function(reason) {
                reason && verdicts.push(
                    {
                        elem: 'verdict',
                        elemMods: {
                            expanded: shouldVerdictsBeExpanded,
                            expandable: verdictsCount === 1 ? 'no' : '',
                            'without-title': reason.title ? '' : 'yes'
                        },
                        tag: 'li',
                        content: [
                            verdictsCount === 1 ?
                                {
                                    block: 'b-quality-verdicts-list',
                                    elem: 'verdict-title',
                                    content: reason.title || ''
                                } :
                                {
                                    block: 'link',
                                    mods: {
                                        pseudo: 'yes',
                                        theme: 'without-border'
                                    },
                                    mix: [
                                        {
                                            block: 'b-quality-verdicts-list',
                                            elem: 'verdict-title',
                                        }, {
                                            block: 'b-metrika',
                                            js: {
                                                goals: [
                                                    'SHOWTEXT', {
                                                        name: 'SHOWTEXT',
                                                        counter: '34'
                                                    }
                                                ]
                                            }
                                        }
                                    ],
                                    content: reason.title || ''
                                },
                            {
                                elem: 'verdict-recommendation',
                                elemMods: {
                                    outdoor: true,
                                    id: reason.id,
                                },
                                content: reason.content
                            },
                        ]
                    }
                )
            }, this)
        }

        return [
            {
                elem: 'title',
                content: this.ctx.title
            },
            {
                elem: 'verdicts-wrapper',
                content: {
                    elem: 'verdicts-list',
                    tag: 'ul',
                    content: [verdicts, verdictsByOperators]
                }
            },
            this.mods.type == 'moderation' && {
                elem: 'moderation-links',
                verdicts: this.ctx.verdicts,
                links: this.ctx.commonLinks ?
                    this.ctx.commonLinks.map(function(link) {
                        return {
                            block: 'link',
                            attrs: link.attrs,
                            mix: {
                                block: 'b-quality-verdicts-list',
                                elem: 'link'
                            },
                            url: link.url,
                            content: link.content
                        };
                    }) : [{
                        block: 'link',
                        attrs: { target: '_blank' },
                        mix: {
                            block: 'b-quality-verdicts-list',
                            elem: 'link'
                        },
                        url: u.getCommonHelpUrl('/direct/troubleshooting/moderation.html#document'),
                        content: iget2('b-quality-verdicts-list', 'otpravit-dokumenty', 'Отправить документы')
                    }, {
                        block: 'link',
                        attrs: { target: '_blank' },
                        mix: {
                            block: 'b-quality-verdicts-list',
                            elem: 'link'
                        },
                        url: u.getCommonHelpUrl('/support/direct/troubleshooting/moderation.html#dissent'),
                        content: iget2('b-quality-verdicts-list', 'ostalis-voprosy-o-prichinah', 'Остались вопросы о причинах отклонения')
                    }]
            },

            verdicts.length ?
                {
                    elem: 'controls',
                    count: verdicts.length
                } :
                {
                    elem: 'verdicts-empty',
                    content: this.ctx.emptyText
                }
        ];
    }),

    elem('controls').content()(function() {
        return {
            block: 'button',
            mods: {
                theme: 'normal',
                pseudo: 'yes'
            },
            mix: [
                {
                    block: 'b-quality-verdicts-list',
                    elem: 'expand-all-button'
                },
                {
                    block: 'b-metrika',
                    js: {
                        goals: [
                            'SHOWTEXT', {
                                name: 'SHOWTEXT',
                                counter: '34'
                            }
                        ]
                    }
                }
            ],
            content: this.expandButtonTexts.expand
        };
    }),

    elem('moderation-links').content()(function() {
        var verdicts = this.ctx.verdicts;
        // Для одной рекомендации отображаем ссылки из нее
        // Для нескольких - ссылки из контекста, по умолчанию
        // Если рекомендация одна - и она про старые причины - тоже отображаем ссылки по умолчанию
        return verdicts && verdicts.length === 1 && verdicts[0].type !== 'old' ?
            verdicts[0].links && verdicts[0].links.map(function(link) {
                return u._.isArray(link) ?
                    link : {
                        block: 'link',
                        attrs: link.attrs || {
                            target: '_blank'
                        },
                        mix: {
                            block: 'b-quality-verdicts-list',
                            elem: 'link'
                        },
                        url: link.url,
                        content: link.content
                    };
            }, this) :
            this.ctx.links
    }));

block('b-quality-verdicts-list').mod('type', 'moderation').elem('controls').def()(function() {
    if (this.ctx.count == 1) return '';

    return applyNext();
});

block('b-quality-verdicts-list').mod('type', 'creative').elem('controls').def()(function() {
    if (this.ctx.count == 1) return '';

    return applyNext();
});
