BEM.DOM.decl('b-quality-verdicts-list', {
    onSetMod: {
        js: function() {
            var _this = this;
            this.isExpanded = false;
            this.expandBtn = this.findBlockOn('expand-all-button', 'button');
            this.popup = this.findBlockOutside('popup');
            this.expandBtn && this.expandBtn.on('click', this.expandAll, this);

            this.on('expand', function() { this.popup.repaint() }, this);

            this.elem('verdict').each(function(i, elem) {
                elem = $(elem);

                if (!_this.hasMod(elem, 'expandable', 'no')) {
                    _this.findBlockInside(elem, 'link').on('click', { elem: elem }, _this.expandBlock, _this);
                }
            });

            setTimeout(function() {
                this.elem('verdicts-wrapper').scrollTop(0);
            }.bind(this), 0);
        }
    },

    /**
     * Сворачивает/разворачивает блок с подробным текстом
     * @param {Object} e
     * @param {Object} e.data
     * @param {Object} e.data.elem
     * @returns {BEM}
     */
    expandBlock: function(e) {
        this.toggleMod(e.data.elem, 'expanded', 'yes', '');

        this.trigger('expand');

        return this.updateExpandedState();
    },

    /**
     * Обновляет состояние кнопки свернуть/развернуть все
     * @returns {BEM}
     */
    updateExpandButtonText: function() {
        var texts = this.params.expandButtonTexts;

        this.expandBtn.elem('text').text(
            this.isExpanded ? texts.fold : texts.expand);

        return this;
    },

    /**
     * Обновляет состояние попапа this.isExpanded
     * @returns {BEM}
     */
    updateExpandedState: function() {
        var expanded = true,
            _this = this;

        if (!this.expandBtn) return;

        this.elem('verdict').each(function(i, elem) {
            expanded = expanded && _this.getMod($(elem), 'expanded');
        });

        this.isExpanded = expanded;

        this.updateScrollState();

        return this.updateExpandButtonText();
    },

    /**
     * Обновляем положение полосы прокрутки в попапе
     * @returns {*}
     */
    updateScrollState: function() {
        //this.elem('verdicts-wrapper').scrollTop(this.elem('verdicts-list').height());

        return this;
    },

    /**
     * Сворачиваем/разворачиваем список рекомендаций
     * @returns {BEM}
     */
    expandAll: function() {
        var _this = this;

        this.isExpanded = !this.isExpanded;

        this.elem('verdict').each(function(i, elem) {
            _this.setMod($(elem), 'expanded', _this.isExpanded ? 'yes' : '');
        });

        this.trigger('expand');

        this.updateScrollState();

        return this.updateExpandButtonText();
    }
}, {

});
