/**
 * Блок для показа сообщения "Мало показов" с тултипом, используется для показа в таблицах ставок (DIRECT-61956)
 *
 * @param {String} this.ctx.adgroupType - тип группы (для подбора текста тултипа и ссылки на help)
 * @param {String} this.ctx.phraseType - тип фразы ('phrases' | 'retargetings' | 'interests' | 'relevance-match')
 * @param {Boolean} this.ctx.isFilter - флаг фильтра
 */
block('b-rarely-served-message')(

    content()(function() {

        return [
            iget2('b-rarely-served-message', 'malo-nbsp-pokazov', 'Мало&nbsp;показов'),
            {
                block: 'b-help-link',
                mix: [
                    {
                        block: 'b-hintable-popup',
                        js: {
                            hint: [
                                u.getRarelyServedTooltipText({
                                    groupType: this.ctx.adgroupType,
                                    phraseType: this.ctx.phraseType,
                                    isFilter: this.ctx.isFilter
                                }) + ' ',
                                {
                                    block: 'b-help-link',
                                    mix: { block: 'b-rarely-served-message', elem: 'link' },
                                    mods: { type: 'modal', decoration: 'no' },
                                    stretched: true,
                                    url: u.getHelpUrl(u.getRarelyServedHelpId({ groupType: this.ctx.adgroupType })),
                                    text: iget2('b-rarely-served-message', 'podrobnee-o-probleme', 'Подробнее о проблеме')
                                }
                            ],
                            directions: ['bottom'],
                            mixPopup: { block: 'b-group-phrase', elem: 'rarely-served-popup' }
                        }
                    }
                ]
            }
        ];
    })
);
