block('b-rates-chooser').mod('multi')(

    elem('content').content()(function() {
        var options = this.ctx.options,
            disabledItems = options.disabledItems,
            prevValue = options.prevValue,
            groups = options.groups || [];

        return {
            block: 'menu',
            mods: { type: 'default', theme: 'normal', size: 'xs', width: 'max', tone: 'default' },
            content: groups.map(function(group) {
                var isMultiChoice = group.isMultiChoice,
                    groupItemsValues = u._.map(group.items, 'value'),
                    isGroupHasDisabledItems = !!u._.intersection(groupItemsValues, disabledItems).length;

                return {
                    elem: 'group',
                    title: group.title,
                    content: isMultiChoice ?
                        group.items.map(function(item) {
                            var value = item.value,
                                isDisabled = u._.includes(disabledItems, value),
                                isChecked = u._.includes(prevValue, value);

                            return {
                                block: 'menu',
                                elem: 'item',
                                elemMods: isDisabled ? { disabled: 'yes' } : undefined,
                                text: {
                                    block: 'checkbox',
                                    mix: { block: 'b-rates-chooser', elem: 'check' },
                                    mods: {
                                        theme: 'normal',
                                        size: 's',
                                        disabled: isDisabled ? 'yes' : '',
                                        checked: isChecked ? 'yes' : '',
                                        lines: false
                                    },
                                    name: value,
                                    text: item.name
                                }
                            };
                        }) :
                        {
                            block: 'radiobox',
                            mods: { theme: 'normal', size: 's' },
                            content: group.items.map(function(item) {

                                return {
                                    block: 'menu',
                                    elem: 'item',
                                    elemMods: isGroupHasDisabledItems ? { disabled: 'yes' } : undefined,
                                    text: {
                                        block: 'radiobox',
                                        elem: 'radio',
                                        elemMods: {
                                            disabled: isGroupHasDisabledItems ? 'yes' : '',
                                            checked: u._.includes(prevValue, item.value) ? 'yes' : ''
                                        },
                                        controlAttrs: { value: item.value },
                                        content: item.name
                                    }
                                };
                            })
                        }
                }
            })
        }
    })

);
