BEM.DOM.decl({ block: 'b-rates-chooser', modName: 'multi' }, {

    onSetMod: {
        js: function() {
            BEM.blocks['radiobox'].on(this.domElem, 'change', this._onControlsChange, this);
            BEM.blocks['checkbox'].on(this.domElem, 'change', this._onControlsChange, this);

            if (this.params.checkLimit) {
                this._minCheckCount = u._.get(this.params, 'checkLimit.min.count');
                this._maxCheckCount = u._.get(this.params, 'checkLimit.max.count');

                this._checkLimit(this._getValue());
            }

            this.__base.apply(this, arguments);
        }
    },

    _getRadioboxes: function() {
        return this._radioboxes || (this._radioboxes = this.findBlocksInside('radiobox'));
    },

    _getCheckboxes: function() {
        return this._checkboxes || (this._checkboxes = this.findBlocksInside('checkbox'));
    },

    _getValue: function() {
        var radioValue = this._getRadioboxes()
                .map(function(radio) {
                    return radio.val();
                })
                .filter(Boolean),
            checkValue = this._getCheckboxes()
                .filter(function(checkbox) {
                    return checkbox.hasMod('checked', 'yes');
                })
                .map(function(checkbox) {
                    return checkbox.name();
                });

        return [].concat(radioValue).concat(checkValue);
    },

    _onControlsChange: function() {
        this.afterCurrentEvent(function() {
            this._applyValue(this._getValue());
        });
    },

    _applyValue: function(value) {
        if (this.params.checkLimit) {
            this._checkLimit(value);
        }

        return this.__base.apply(this, arguments);
    },

    _checkLimit: function(value) {
        var checkedCount = value.length;

        if (checkedCount <= this._minCheckCount) {
            // Все выбранные - задизейблить
            this._getCheckboxes().forEach(function(checkbox) {
                checkbox.setMod('disabled', checkbox.hasMod('checked', 'yes') ? 'yes' : '')
            });

            this._disabledText = u._.get(this.params, 'checkLimit.min.text');
        } else if (checkedCount >= this._maxCheckCount) {
            // Все НЕ выбранные - задизейблить
            this._getCheckboxes().forEach(function(checkbox) {
                checkbox.setMod('disabled', checkbox.hasMod('checked', 'yes') ? '' : 'yes')
            });

            this._disabledText = u._.get(this.params, 'checkLimit.max.text');
        } else {
            // Все раздизейблить
            this._getCheckboxes().forEach(function(checkbox) {
                checkbox.delMod('disabled');
            });
            this._disabledText = '';
        }
    },

    _onMenuItemClick: function(e, data) {},

    /**
     * Обработчик измененеия модификатора `disabled` на чекбоксах - устанавливает такой же на `menu__item`
     * @param {jQuery.Event} e
     * @private
     */
    _onCheckEnableDisable: function(e) {
        var check = e.block,
            disabledVal = check.getMod('disabled'),
            menuItem = e.block.domElem.closest(BEM.blocks['menu'].buildSelector('item')),
            menu = this.blockInside('menu');

        if (menuItem.length && menu) {
            menu.setMod(menuItem, 'disabled', disabledVal)
        }
    },

    /**
     * Показывает подсказку
     * @param {jQuery} domElem
     * @param {String} text
     * @private
     */
    _showTooltip: function(domElem, text) {
        this._tipman || (this._tipman = BEM.create('tipman', {
            tipMods: { theme: 'normal' },
            popupDirections: ['right', 'bottom'],
            delay: 0,
            onScrollClose: false
        }));

        if (text) {
            this._tipman.show({
                owner: domElem,
                content: text
            });

            // Такой костыль так как _calcIsAnchorVisible для попапа с тултипом возвращает false
            // из-за большой вложености попапов https://jing.yandex-team.ru/files/cyn/Image_2019-03-24_13-55-19.png
            this.afterCurrentEvent(function() {
                try {
                    this._tipman._getPopup().domElem.show();
                } catch (e) { }
            });

        }
    },

    /**
     * Прячет подсказку
     * @private
     */
    _hideTooltip: function() {
        this._tipman && this._tipman.hide();
    },

    /**
     * Обработчик событий pointerover pointerout на элементе `check`
     * @param {jQuery.Event} e
     * @private
     */
    _onCheckPointerOverOut: function(e) {
        var domElem = e.data.domElem,
            checkbox = this.findBlockOn(domElem, 'checkbox');

        if (checkbox && checkbox.hasMod('disabled')) {
            if (e.type === 'pointerover') {
                this._showTooltip(domElem, this._disabledText);
            } else {
                this._hideTooltip();
            }
        }
    }

}, {

    live: function() {
        this
            .liveInitOnBlockInsideEvent(
                { modName: 'disabled', modVal: 'yes' },
                'checkbox',
                function(e) {
                    this._onCheckEnableDisable(e)
                }
            )
            .liveInitOnBlockInsideEvent({ modName: 'disabled', modVal: '' }, 'checkbox', function(e) {
                this._onCheckEnableDisable(e);
            })
            .liveBindTo('check', 'pointerover pointerout', function(e, data) {
                this._onCheckPointerOverOut(e);
            });

        return this.__base.apply(this, arguments);
    }

});
