block('b-rates-chooser')(

    replace()(function() {
        var options = this.ctx.options;

        return {
            block: 'popup2',
            mods: { target: 'anchor', theme: 'normal', autoclosable: 'yes' },
            mix: {
                block: this.block,
                mods: this.mods,
                js: u._.pick(options, 'checkLimit')
            },
            zIndexGroupLevel: 6,
            directions: ['bottom-left', 'top-left'],
            content: {
                block: this.block,
                mods: this.mods,
                elem: 'content',
                options: options
            }
        }
    }),

    elem('content')(
        content()(function() {
            var options = this.ctx.options,
                disabledItems = options.disabledItems,
                prevValue = options.prevValue,
                groups = options.groups || [];

            return {
                block: 'menu',
                mods: { type: 'default', theme: 'normal', size: 'xs', width: 'max', tone: 'default' },
                items: groups.map(function(group) {
                    var isGroupMultiChoice = group.isMultiChoice,
                        groupItemsValues = u._.map(group.items, 'value');

                    return {
                        title: group.title,
                        items: group.items.map(function(item) {
                            var value = item.value,
                                isDisabled = isGroupMultiChoice ?
                                    u._.includes(disabledItems, value) || u._.includes(prevValue, value) :
                                    u._.includes(groupItemsValues, disabledItems) &&
                                        !u._.includes(groupItemsValues, prevValue);

                            return {
                                text: item.name,
                                val: value,
                                elemMods: isDisabled ? { disabled: 'yes' } : undefined
                            };
                        })
                    }
                })
            };
        })
    ),

    elem('add-button-content').content()(function() {
        var count = this.ctx.count;

        return count ?
            iget2('b-rates-chooser', 'add-count', 'Добавить — {count}', { count: String(count) }) :
            iget2('b-rates-chooser', 'add', 'Добавить');
    })

);
