BEM.DOM.decl('b-rates-chooser', {

    show: function() {
        this._owner.data(this.__self.getName(), this.params.uniqId);

        this.blockInside('popup2')
            .setAnchor(this._owner)
            .setMod('visible', 'yes');

        return this;
    },

    hide: function() {
        this.blockInside('popup2').delMod('visible');

        return this;
    },

    isOpen: function() {
        return this.blockInside('popup2').hasMod('visible', 'yes');
    },

    setOwner: function(owner) {
        this._owner = owner;

        return this;
    },

    _onBeforePopupOpen: function() {
        this.trigger('beforeOpen');
    },

    _onBeforePopupClose: function() {
        this._owner.data(this.__self.getName(), null);

        this.trigger('beforeClose');

        setTimeout(function() {
            BEM.DOM.destruct(this.domElem);
        }.bind(this), 100);
    },

    _onMenuItemClick: function(e, data) {
        var value = e.block.elemParams(data.item).val;

        this._applyValue(value);
        this.hide();
    },

    _applyValue: function(value) {
        this._notify(value);
    },

    _notify: function(value) {
        this.trigger('change', { value: value });
    }

}, {

    get: function(options) {
        var block = this.getName(),
            owner = options.owner,
            prevChooser,
            prevChooserUniqId = owner.data(block);

        if (prevChooserUniqId) {
            prevChooser = this.getBlockByUniqId(prevChooserUniqId);

            if (prevChooser) {
                return prevChooser;
            }
        }

        return BEM.DOM.init(
            BEMHTML.apply({
                block: block,
                mods: {
                    multi: options.isMultiChoice ? (options.isMultiChoiceButton ? 'button' : true) : ''
                },
                options: u._.pick(
                    options,
                    ['disabledItems', 'groups', 'prevValue', 'checkLimit']
                )
            })
        )
            .bem(block)
            .setOwner(owner);
    },

    live: function() {
        this
            .liveInitOnBlockEvent('beforeClose', 'popup2', function() {
                this._onBeforePopupClose();
            })
            .liveInitOnBlockEvent('beforeOpen', 'popup2', function() {
                this._onBeforePopupOpen();
            })
            .liveInitOnBlockInsideEvent('click', 'menu', function(e, data) {
                this._onMenuItemClick(e, data);
            });

        return false;
    }

});
