u.register({
    'b-rates-chooser': {

        weather: {
            getParameters: function() {
                return [
                    'temp',
                    // 'prec_type',
                    'prec_strength',
                    'cloudness'
                ];
            },

            getParameterValues: function(parameter) {
                return u._.get(
                    u.consts('WEATHER_MULTIPLIER_CONSTRAINTS'),
                    [parameter, 'values'],
                    []
                )
            },

            getParameterText: function(key) {
                return {
                    temp: iget2('b-rates-chooser', 'temp','Температура'),
                    // prec_type: iget2('b-rates-chooser', 'prec_type', 'Тип осадков'),
                    prec_strength: iget2('b-rates-chooser', 'prec_strength','Осадки'),
                    cloudness: iget2('b-rates-chooser', 'cloudness','Облачность')
                }[key];
            },

            getParameterValueText: function(key, value) {
                var texts = {
                    // prec_type: {
                    //     0: iget2('b-rates-chooser', 'prec_type_0', 'нет'),
                    //     1: iget2('b-rates-chooser', 'prec_type_1','дождь'),
                    //     3: iget2('b-rates-chooser', 'prec_type_3','снег')
                    // },
                    prec_strength: {
                        0: iget2('b-rates-chooser', 'prec-strength_0', 'Нет'),
                        25: iget2('b-rates-chooser', 'prec-strength_25', 'Небольшие'),
                        50: iget2('b-rates-chooser', 'prec-strength_50', 'Средние'),
                        75: iget2('b-rates-chooser', 'prec-strength_75', 'Сильные'),
                        100: iget2('b-rates-chooser', 'prec-strength_100', 'Ливень/снегопад')
                    },
                    cloudness: {
                        0: iget2('b-rates-chooser', 'cloudness_0','Ясно'),
                        25: iget2('b-rates-chooser', 'cloudness_25','Небольшая'),
                        50: iget2('b-rates-chooser', 'cloudness_50','Средняя'),
                        75: iget2('b-rates-chooser', 'cloudness_75','Значительная'),
                        100: iget2('b-rates-chooser', 'cloudness_100','Сплошная')
                    }
                };

                return u._.get(texts, [key, value].join('.'), '');
            }
        },

        devices: {},

        cpmGroupType: {

            getGroupIds: function() {
                return ['banners', 'inventory'];
            },

            getGroupIdByRateType: function(rateType) {
                if (u._.includes(u.consts('INVENTORY_MULTIPLIER_TYPES'), rateType)) {
                    return 'inventory';
                } else if (u._.includes(u.consts('BANNER_TYPE_MULTIPLIER_TYPES'), rateType)) {
                    return 'banners';
                }
            },

            getRateTypes: function(groupName) {
                switch (groupName) {
                    case 'inventory':
                        //return ['instream_web', 'inpage', 'interstitial', 'inbanner', 'rewarded'];
                        return u.consts('isFeatureVideoInventoryModifiersEnabled') ?
                            u.consts('INVENTORY_MULTIPLIER_TYPES') :
                            u._.difference(u.consts('INVENTORY_MULTIPLIER_TYPES'), ['inbanner', 'rewarded']);
                    case 'banners':
                        //return ['cpm_banner'];
                        return u.consts('BANNER_TYPE_MULTIPLIER_TYPES');
                    default:
                        return []
                            .concat(u.consts('INVENTORY_MULTIPLIER_TYPES'))
                            .concat(u.consts('BANNER_TYPE_MULTIPLIER_TYPES'));
                }
            },

            getText: function(key) {
                return {
                    inventory: iget2('b-rates-chooser', 'inventory', 'Видео'),
                    banners: iget2('b-rates-chooser', 'cpm-banners', 'Баннеры'),
                    instream_web: iget2('b-rates-chooser', 'instream-web', 'В потоковом видео'),
                    inpage: iget2('b-rates-chooser', 'inpage', 'В текстовом контенте'),
                    interstitial: iget2('b-rates-chooser', 'interstitial', 'В приложениях'),
                    inbanner: iget2('b-rates-chooser', 'inbanner', 'Видео в баннере'),
                    rewarded: iget2('b-rates-chooser', 'rewarded', 'Видео за вознаграждение'),
                    cpm_banner: iget2('b-rates-chooser', 'all-cpm-banner', 'Все баннеры')
                }[key];
            }
        },

        trafficJam: {

            getValues: function() {
                return ['0', '1', '2', '3'];
            },

            getText: function(key) {
                return {
                    0: iget2('b-rates-chooser', 'traffic-jam-value-0', 'Нет пробок'),
                    1: iget2('b-rates-chooser', 'traffic-jam-value-1', 'Движение затруднено'),
                    2: iget2('b-rates-chooser', 'traffic-jam-value-2', 'Пробки'),
                    3: iget2('b-rates-chooser', 'traffic-jam-value-3', 'Серьёзные пробки')
                }[key];
            }

        }

    }
});
