block('b-regions-adapter').replace()(function() {
    var params = u.consts('regionTreeParams');

    return {
        block: 'b-regions',
        mix: {
            block: 'b-regions-adapter',
            mods: this.ctx.mods
        },
        mods: this.ctx.mods,
        regions: u.getRegionsTree(params.lang + (params.translocalTreeType === 'ru' ? '_for_ru' : '')),
        disableRegions: this.ctx.disableRegions,
        //DIRECT-58772 Для Украины Крым не чекаем при чеканьи родителя
        independentRegions: u.consts('client_country') === '187' ? [977] : [],
        quickSelectRegions: !/yandex.com.tr/.test(u.consts('yandex_domain')) && [
            {
                id: u.REGIONS.MOSCOW_AND_AREA,
                name: iget2('b-regions-adapter', 'moskva-i-oblast', 'Москва и область')
            },
            {
                id: u.REGIONS.ST_PETERBURG_AND_AREA,
                name: iget2('b-regions-adapter', 'sankt-peterburg-i-oblast', 'Санкт-Петербург и область')
            },
            {
                id: u.REGIONS.UKRAINE,
                name: iget2('b-regions-adapter', 'ukraina', 'Украина')
            },
            {
                id: [u.REGIONS.RUSSIA, u.REGIONS.CIS, u.REGIONS.GEORGIA],
                name: iget2('b-regions-adapter', 'rossiya-sng-i-gruziya', 'Россия, СНГ и Грузия')
            }
        ],
        quickSelectUserRegion: params.geoSuggest && {
            id: params.geoSuggest,
            name: u.getGeoNames(params.geoSuggest)
        }
    };
});
