BEM.DOM.decl({ block: 'b-regions-adapter', implements: 'i-outboard-controls' }, {

    getRegions: function() {
        return this._regions || (this._regions = this.findBlockOn('b-regions'));
    },

    setSelectedRegions: function(idsString) {
        this.getRegions().setSelectedRegions(idsString.split(/[\s|,]+/));
    },

    /**
     *  Возвращает  значение региона
     * @returns {*}
     */
    getGeoValue: function() {
        return this._model.get('geo');
    },

    /**
     * Инициализация контрола перед показом
     * @param {Object} params
     */
    prepareToShow: function(params) {
        this._model = BEM.MODEL.getOne({ name: 'm-geo-regions', id: params.modelId });
        this.setSelectedRegions(((this._model.get('geo') || '') + ''));

        this._regions.setMod(
            'has-independent-filter-warning',
            this._model.get('hasIndependentRegionsWarning') ? 'yes' : ''
        );
    },

    /**
     * Подтверждение изменения данных (обновление модели)
     */
    provideData: function() {
        var regionsData = this.getRegions().getRegionsData();

        this._model
            .update({
                geo: regionsData.ids.join(',') || 0,
                geoText: regionsData.text,
                hasIndependentRegionsWarning: this._regions.hasMod('has-independent-filter-warning')
            })
            .fix();
    },

    declineChange: function() { }

}, {

    live: true

});
