/**
* @fires b-regions-selector#open-popup событие открытия попапа редактирования регионов показа
* @fires b-regions-selector#save событие сохранения настроек регионов в попапе
*/
BEM.DOM.decl({ block: 'b-regions-selector', modName: 'with-validation', modVal: 'yes' }, {
    /**
     * Валидирует выбранные регионы
     * @param {Object} data
     * @return {boolean}
     * @private
     */
    _validateRegions: function(data) {
        // в базе валидации нет
        var deferred = $.Deferred();

        this._checkCommonGeo(this.params.cid, data.geoChangesJson)
            .then(function(response) {
                deferred.resolveWith(this, [response]);
            }, function(response) {
                var parsedErrors = u['b-regions-selector']._parseErrors(response.errors);
                deferred.rejectWith(this, [u['b-regions-selector']._getErrorsText(parsedErrors)]);
            });

        return deferred.promise();
    },

    /**
     * Серверная валидация гео
     * @param {String} cid - id кампании
     * @param {Object} geoChangesJson - объект изменений регионов
     * @return {$.Deferred}
     * @private
     */
    _checkCommonGeo: function(cid, geoChangesJson) {
        var deferred = $.Deferred(),
            request;

        // при пустых изменениях ходить на сервер за проверкой не нужно
        if (geoChangesJson !== '{}') {
            request = BEM.create('i-request_type_ajax', {
                url: '/registered/main.pl',
                type: 'POST',
                cache: false,
                dataType: 'json',
                callbackCtx: this
            });

            this._checkCommonGeoRequest = request.get(
                { cmd: 'ajaxCheckCommonGeo', cid: cid, json_geo_changes: geoChangesJson },
                function(response) {
                    if (response.errors || !response.ok) {
                        deferred.rejectWith(this, [response]);
                    } else if (response.ok) {
                        deferred.resolveWith(this, [response]);
                    }
                },
                function(response) {
                    deferred.rejectWith(this, [response]);
                },
                { callbackCtx: this, timeout: 60000 });
        } else {
            deferred.resolveWith(this, [{}]);
        }

        return deferred.promise();
    },

    /**
     * @protected
     */
    _abortRegionsPopupRequests: function() {
        if (this._checkCommonGeoRequest) {
            this._checkCommonGeoRequest.abort();
            this._checkCommonGeoRequest = null;
        }
    }
});
