block('b-regions-selector')(

    def()(function() {
        var ctx = this.ctx,
            // DIRECT-67057: 9961: не показывается подрегион при редактировании объявления.
            // в группах используется строка со списком регионов, которая не всегда сохраняет последовательность
            // приводим ее к правильному виду
            // TODO DIRECT-67228: b-regions-tree:
            // TODO оптимизировать обход дерева и научится строить дерево по id-шникам регионов в любом порядке
            geo,
            regionsTreeInfoParams = ctx.regionsTreeInfoParams,
            geoText = ctx.geoText;

        if (this.ctx.geo) {
            // имитируем хеш(по аналогии с campaign.extended_geo)
            var regionsTreeInfo = u.getRegionsTreeInfo(
                u.getRegionsTree(regionsTreeInfoParams.lang),
                u.geoStringToFakeObject(this.ctx.geo),
                regionsTreeInfoParams
            );

            geo = regionsTreeInfo.treeStateValue || '0';
            geoText = u.getGeoNames(regionsTreeInfo.treeStateValue);
        }

        return applyNext({
            // Поле geo про значение, geoState - про галочки в попапе
            // (сделано так как для массового редактирования на странице параметров кампании между галки и значение ведут себя по-разному)
            // Если geoState не указано - то галочки ставятся на основании поля geo
            geo: ctx.geoState || geo,
            bids: ctx.bids,
            geoText: geoText,
            productType: ctx.productType,
            modelId: ctx.modelParams.id,
            hintAboveControl: ctx.hintAboveControl || false,
            hintMixes: ctx.hintMixes
        });
    }),

    js()(function() {
        var ctx = this.ctx,
            geoSuggestForQuickSelect = ctx.geoSuggestForQuickSelect;

        return {
            regions: ctx.regions,
            disableRegions: ctx.disableRegions,
            //DIRECT-58772 Для Украины Крым не выбираем
            // independentRegions: u.consts('client_country') === u.REGIONS.UKRAINE ? [u.REGIONS.CRIMEA] : [],
            quickSelectRegions: u.consts('yandex_domain') !== 'yandex.com.tr' && [
                {
                    id: u.REGIONS.MOSCOW_AND_AREA,
                    name: iget2('b-regions-selector', 'moskva-i-oblast', 'Москва и область')
                },
                {
                    id: u.REGIONS.ST_PETERBURG_AND_AREA,
                    name: iget2('b-regions-selector', 'sankt-peterburg-i-oblast', 'Санкт-Петербург и область')
                },
                {
                    id: u.REGIONS.UKRAINE,
                    name: iget2('b-regions-selector', 'ukraina', 'Украина')
                },
                {
                    id: [u.REGIONS.RUSSIA, u.REGIONS.CIS, u.REGIONS.GEORGIA],
                    name: iget2('b-regions-selector', 'rossiya-sng-i-gruziya', 'Россия, СНГ и Грузия')
                }
            ],
            quickSelectUserRegion: geoSuggestForQuickSelect && {
                id: geoSuggestForQuickSelect,
                name: u.getGeoNames(geoSuggestForQuickSelect)
            },
            isCommon: ctx.isCommon,
            hasBidsCorrections: ctx.hasBidsCorrections,
            bids: this.bids,
            isBidsCorrectionsModeOn: ctx.isBidsCorrectionsModeOn,
            disableEditBids: ctx.disableEditBids,
            disableEditBidsHint: ctx.disableEditBidsHint,
            cid: ctx.cid,
            hintForDifferentRegions: ctx.hintForDifferentRegions
        };
    }),

    mix()(function() {
        return [{
            // нужно для инита модели, когда i-model не успевает создать модель
            block: 'i-glue',
            js: {
                modelParams: this.ctx.modelParams,
                modelData: {
                    geo: this.geo,
                    geoText: this.geoText,
                    // ignore stringify
                    geoChangesJson: JSON.stringify(this.ctx.geoChanges),
                    productType: this.productType,
                    bids: this.bids,
                    isBidsCorrectionsModeOn: +this.ctx.isBidsCorrectionsModeOn
                }
            }
        }];
    }),

    content()(function() {
        var ctx = this.ctx,
            res = [],
            hintAboveControl = this.hintAboveControl,
            hasBidsCorrections = ctx.hasBidsCorrections,
            disableEditBids = ctx.disableEditBids,
            isBidsCorrectionsModeOn = ctx.isBidsCorrectionsModeOn,
            bids = this.bids,
            hintContent = {
                elem: 'hint',
                mix: this.hintMixes,
                content: [
                    {
                        elem: 'selected-regions',
                        mix: [
                            {
                                block: 'i-glue',
                                elem: 'model-field',
                                js: { name: 'geoText', type: 'inline' }
                            }
                        ],
                        content: u.escapeHTML(this.geoText || ctx.emptyText)
                    },
                    hasBidsCorrections && !disableEditBids && {
                        elem: 'bids-hint',
                        elemMods: {
                            hidden: isBidsCorrectionsModeOn && Object.keys(bids).length > 0 ? '' : 'yes'
                        },
                        content: iget2('b-regions-selector', 'dobavlena-korrektirovka-stavok-po', 'Добавлена корректировка ставок по регионам показа')
                    }
                ]
            };

        // @anyakey для DIRECT-51225: переносим хинт над контролом
        // @dima117a название парамера не отражает его смысл. на самом деле, это
        // флаг, включающий особый режим блока "на странице параметров кампании"
        // (там особое отображение хинта и особые тема и текст на кнопке)
        this.hintAboveControl && res.push(hintContent);

        ctx.isEditable && res.push({
            block: 'button',
            mods: {
                theme: 'normal'
            },
            mix: {
                block: 'b-regions-selector',
                elem: 'switcher'
            },
            content: hintAboveControl ? iget2('b-regions-selector', 'izmenit', 'Изменить') : iget2('b-regions-selector', 'utochnit-115', 'Уточнить')
        });

        !hintAboveControl && res.push(hintContent);

        // isCommon = true, если кампания не mcb-шная
        if (ctx.isCommon) {
            res.push({
                elem: 'geo-hidden',
                mix: [{
                    block: 'i-glue',
                    elem: 'model-field',
                    js: {
                        name: 'geoChangesJson',
                        type: 'native'
                    }
                }],
                name: 'json_geo_changes',
                value: this.ctx.geoChanges || {}
            });
        } else {
            res.push({
                elem: 'geo-hidden',
                mix: [{
                    block: 'i-glue',
                    elem: 'model-field',
                    js: {
                        name: 'geo',
                        type: 'native'
                    }
                }],
                name: ctx.geoHiddenName || 'geo',
                value: this.geo
            });
        }

        if (hasBidsCorrections && !disableEditBids) {
            res.push({
                elem: 'geo-hidden',
                mix: [{
                    block: 'i-glue',
                    elem: 'model-field',
                    js: {
                        name: 'bidsJson',
                        type: 'native'
                    }
                }],
                name: 'json_geo_multipliers',
                value: bids
            });

            res.push({
                elem: 'geo-hidden',
                mix: [{
                    block: 'i-glue',
                    elem: 'model-field',
                    js: {
                        name: 'isBidsCorrectionsModeOn',
                        type: 'native'
                    }
                }],
                name: 'geo_multipliers_enabled',
                value: +isBidsCorrectionsModeOn
            });
        }

        return res;
    }),

    elem('geo-hidden')(

        tag()('input'),

        attrs()(function() {
            return {
                type: 'hidden',
                name: this.ctx.name + '',
                value: typeof (this.ctx.value) === 'object' ? JSON.stringify(this.ctx.value) : this.ctx.value + ''
            };
        })
    ),

    elem('geo-warning').content()(function() {
        return [
            {
                block: 'icon',
                mods: { 'size-13': 'alert' },
                mix: [{
                    block: 'b-regions-selector',
                    elem: 'warning-icon'
                }]
            },
            iget2(
                'b-regions-selector',
                'utochnenie-regiona-povyshaet-effektivnost',
                'Уточнение региона повышает эффективность вашей рекламы.'
            )
        ];
    })
);
