(function() {

    u.register({
        'b-regions-selector': {
            /**
             * @typedef {'#empty_geo#'} ErrorKey
             */

            /**
             * @typedef {Object} ServerErrorsFormat
             *
             * @property {Object} [<groupId>] - ключ это номер группы, внутри объект с ошибками
             * @property {Array<String|ErrorKey>} [<groupId>.geo] - ошибки гео (например #empty_geo# или просто текст)
             */

            /**
             * @typedef {Object} FormattedError - данные об ошибке
             *
             * @property {String} text - текст ошибки или ключ <ErrorKey>
             * @property {String} [groups] - список групп в которых присутствует ошибка
             */

            /**
             * Парсит данные об ошибках
             * @param {ServerErrorsFormat} errors
             * @return {Array<FormattedError>}
             * @private
             */
            _parseErrors: function(errors) {
                var groupIds = Object.keys(errors || {}),
                    result = [];

                groupIds.forEach(function(groupId) {
                    var geoErrors = u._.get(errors, groupId + '.geo', []);

                    geoErrors.forEach(function(text) {
                        var error = u._.find(result, { text: text }) ||
                            (result[result.push({ text: text, groups: [] }) - 1]);

                        error.groups.push('№' + groupId);
                    });
                });

                return result;
            },

            /**
             * Возвращает массив с текстами ошибок
             * @param {Array<FormattedError>} parsedErrors
             * @return {Array<String>}
             * @private
             */
            _getErrorsText: function(parsedErrors) {
                var result = [],
                    commonErrorText = iget2(
                        'b-regions-selector',
                        'nevozmozhno-sohranit-proizoshla-neizvestnaya',
                        'Невозможно сохранить, произошла неизвестная ошибка. Обратитесь в службу поддержки.'
                    ),
                    timeoutErrorText = iget2(
                        'b-regions-selector',
                        'nevozmozhno-sohranit-iz-za',
                        'Невозможно сохранить из-за большого количества групп в кампании. Повторите попытку через API или Коммандер.'
                    );

                parsedErrors.forEach(function(error) {
                    if (error.text === '#empty_geo#') {
                        result.push(
                            u.pluralForms(
                                iget2(
                                    'b-regions-selector',
                                    'v-gruppe-gruppah-gruppah',
                                    'В {группе|группах:|группах:} {foo} применение изменений удалит все регионы показа. Расширьте геотаргетинг этих групп или уменьшите количество удаляемых регионов.',
                                    {
                                        foo: error.groups.join(', ')
                                    }
                                ),
                                error.groups.length
                            )
                        )
                    } else if (error.text) {
                        result.push(error.text);
                    } else {
                        result.push(commonErrorText);
                    }
                });

                if (result.length === 0) {
                    result.push(timeoutErrorText);
                }

                return result;
            }
        }
    });

}());
