// TODO DIRECT-67277: b-regions-tree: оптимизировать ссылки на группы
block('b-regions-tree')(
    elem('contrast-value-info').content()(function() {
        var extraParams = this.ctx.regionData.extraParams,
            campaignData = extraParams.campaignData,
            itemsNumber = extraParams.contrastGroupsCount;

        return [
            iget2('b-regions-tree', 'gruppy-v-kotoryh-dannyy', 'Группы, в которых данный регион показа выключен:'),
            {
                elem: 'contrast-value-items',
                content: itemsNumber > u.consts('maxContrastGroupsInRegion') ?
                    {
                        elem: 'contrast-value-items-text',
                        content: iget2('b-regions-tree', 'v-s-region-pokaza', 'В {foo} регион показа выключен. Список слишком длинный для показа.', {
                            foo: u.pluralize([iget2('b-regions-tree', 'gruppe', 'группе'), iget2('b-regions-tree', 'gruppah', 'группах'), iget2('b-regions-tree', 'gruppah', 'группах')], itemsNumber)
                        })
                    } :
                    this.ctx.groups.map(function(group) {
                        return {
                            elem: 'contrast-value-item',
                            content: [
                                {
                                    block: 'link',
                                    url: u.getUrl(
                                        u.campaign.getEditCmdByMediaType(campaignData.mediaType),
                                        {
                                            cid: campaignData.cid,
                                            adgroup_ids: group.id,
                                            ulogin: u.consts('ulogin'),
                                            showRegionsPopup: true
                                        }
                                    ),
                                    target: '_blank',
                                    content: group.name
                                },
                                {
                                    elem: 'contrast-value-item-id',
                                    content: group.id
                                }
                            ]
                        };
                    })
            }
        ];
    })
);
