block('b-remoderated-outdoor').elem('list').elemMod('sent', 'yes')(
    content()(function() {
        var placementPages = this.ctx.placementPages || [];

        return placementPages.map(function(page) {
            var statusModerate = page.statusModerate.toLowerCase(),
                statusModerateOperator = page.statusModerateOperator.toLowerCase();

            return {
                elem: 'item',
                elemMods: {
                    status: statusModerate,
                    'status-operator': statusModerateOperator,
                    page: page.id
                },
                content: {
                    block: 'checkbox',
                    mods: {
                        disabled: statusModerate === 'ready' ? 'yes' : ''
                    },
                    mix: [
                        {
                            block: 'b-checkboxes-group',
                            elem: 'item'
                        },
                        {
                            block: this.block,
                            elem: 'checkbox'
                        }
                    ],
                    checkboxAttrs: {
                        autocomplete: 'off',
                        value: page.id
                    },
                    text: {
                        elem: 'label',
                        mix: {
                            block: this.block,
                            elem: 'label'
                        },
                        content: {
                            block: this.block,
                            elem: 'placement',
                            pageId: page.id,
                            version: u.consts('rights').showBannerIdInfo ? page.version : undefined,
                            status: statusModerate,
                            statusOperator: statusModerateOperator
                        }
                    }
                }
            };
        }, this);
    })
);
