BEM.DOM.decl({ block: 'b-remoderated-outdoor', modName: 'sent', modVal: 'yes' }, {

    /**
     * Массив id выбранных чекбоксов
     */
    _checkedIds: [],

    onSetMod: {
        js: function() {
            this._bannerModel = BEM.MODEL.getOne({ name: 'dm-cpm-banner', id: this.params.bid });
        }
    },

    onElemSetMod: {
        item: {
            status: {
                ready: function(elem, modName, modVal) {
                    this.findBlockInside(elem, 'checkbox')
                        .delMod('checked')
                        .setMod('disabled', 'yes');

                    BEM.DOM.replace(this.findElem(elem, 'placement'), BEMHTML.apply({
                        block: this.__self.getName(),
                        elem: 'placement',
                        pageId: this.getMod(elem, 'page'),
                        status: modVal,
                        statusOperator: this.getMod(elem, 'status-operator')
                    }));
                }
            },

            progress: {
                yes: function(elem) {
                    this.findBlockInside(elem, 'checkbox').setMod('disabled', 'yes');
                },

                '': function(elem) {
                    this.hasMod(elem, 'status', 'ready') ||
                        this.findBlockInside(elem, 'checkbox')
                            .delMod('checked')
                            .delMod('disabled');
                }
            }
        }
    },

    /**
     * Возвращает id выбранных чекбоксов
     * @returns {Array}
     * @private
     */
    _getCheckedIds: function() {
        return this.blockInside('b-checkboxes-group').getChecked().map(function(checkbox) {
            return checkbox.val();
        });
    },

    /**
     * Скрывает popup2
     * @returns {BEM}
     * @private
     */
    _hidePopup: function() {
        var popup2 = this.blockInside('popup2');

        popup2 && popup2.delMod('visible');

        return this;
    },

    /**
     * Реакция на любое изменение статусов модерации
     * @returns {BEM}
     * @private
     */
    _onStatusChange: function() {
        this.blockInside('checkbox').delMod('checked');
        this.delMod(this.elem('item'), 'progress');

        this.blockInside('button2')
            .delMod('progress')
            .setMod('disabled', 'yes');

        this._checkedIds = [];

        return this;
    },

    /**
     * Обработчик успешного ответа
     * @param {Object} response
     * @private
     */
    _onRemoderateSuccess: function(response) {
        if (response.success) {
            var placementPages = this._bannerModel.get('placement_pages');

            this._checkedIds.forEach(function(id) {
                placementPages.getById(id).set('statusModerate', 'Ready');

                this.setMod(this.elem('item', 'page', id), 'status', 'ready');
            }, this);

            this
                ._hidePopup()
                ._onStatusChange();
        } else {
            this._onRemoderateError(response);
        }
    },

    /**
     * Обработчик ошибок
     * @param {Object} [response]
     * @private
     */
    _onRemoderateError: function(response) {
        var _this = this;

        this._onStatusChange();

        BEM.blocks['b-confirm'].open({
            type: 'alert',
            message: iget2('b-remoderated-outdoor', 'default-error', 'Что-то пошло не так. Попробуйте пожалуйста позже.'),
            onYes: function() {
                _this._hidePopup();
            }
        });
    },

    /**
     * Обработчик события click на кнопке «Отправить»
     * @private
     */
    _onButtonClick: function() {
        this._checkedIds = this._getCheckedIds();

        this.setMod(this.elem('item'), 'progress', 'yes');
        this.blockInside('button2').setMod('progress', 'yes');

        BEM.blocks['i-web-api-request'].bannerPagesModeration
            .remoderateBannerPage(u.consts('ulogin'), { banner_id: this.params.bid, page_ids: this._checkedIds })
            .then(this._onRemoderateSuccess.bind(this))
            .catch(this._onRemoderateError.bind(this));
    },

    /**
     * Обработчик события click на checkbox
     * @private
     */
    _onCheckboxClick: function() {
        if (this._getCheckedIds().length) {
            this.blockInside('button2').delMod('disabled');
        } else {
            this.blockInside('button2').setMod('disabled', 'yes');
        }
    },

    /**
     * Обработчик события beforeOpen блока popup2
     * @private
     */
    _onBeforePopupOpen: function() {
        var checkboxesGroup = this.blockInside('b-checkboxes-group'),
            someIsActive = checkboxesGroup.getCheckboxes().some(function(checkbox) {
                return !checkbox.isDisabled();
            });

        checkboxesGroup.unCheckAll();
        this.blockInside('button2').setMod('disabled', 'yes');
        this.blockInside('checkbox').setMod('disabled', 'yes');

        someIsActive && this.blockInside('checkbox').delMod('disabled');
    }
}, {

    live: function() {
        this
            .liveInitOnBlockInsideEvent('click', 'button2', function() {
                this._onButtonClick();
            })
            .liveInitOnBlockInsideEvent('click', 'checkbox', function() {
                this._onCheckboxClick();
            })
            .liveInitOnBlockEvent('beforeOpen', 'popup2', function() {
                this._onBeforePopupOpen();
            });
    }

});
