(function() {

    var getUrl = BEM.blocks['i-utils'].getUrl;

    BEM.DOM.decl('b-report-links', {

        onSetMod: {
            js: function() {
                this._reportUrl = function(type) {
                    return getUrl('getReport', $.extend({ type: type }, this._ulogin));
                };
            }
        },

        _prevButton: null,

        _getPopup: function() {
            return this._popup ||
                (this._popup = $(BEMHTML.apply({
                    block: 'popup',
                    mix: [{ block: 'b-report-links', elem: 'popup' }],
                    mods: { theme: 'ffffff' },
                    content: [
                        { elem: 'tail' },
                        { elem: 'close' },
                        {
                            elem: 'content',
                            content: ''
                        }
                    ]
                }))
                    .appendTo(BEM.blocks['b-page'].getInstance().domElem)
                    .bem('popup'));
        },

        _getLinks: function() {
            var items = [];

            this.params.isMedia || items.push(
                { text: iget2('b-report-links', 'novye-kampanii-ozhidayushchie-prihoda', 'Новые кампании, ожидающие прихода денег'), url: this._reportUrl(1) },
                { text: iget2('b-report-links', 'rabotavshie-kampanii-ozhidayushchie-prihoda', 'Работавшие кампании, ожидающие прихода денег'), url: this._reportUrl(2) },
                { text: iget2('b-report-links', 'zakanchivayushchiesya-kampanii', 'Заканчивающиеся кампании'), url: this._reportUrl(3) },
                { text: iget2('b-report-links', 'zakonchivshiesya-kampanii-na-kotorye', 'Закончившиеся кампании, на которые не выписан счёт'), url: this._reportUrl(4) });

            (!this.params.isMedia || this.params.isSuperMediaPlanner) && items.push({
                text: iget2('b-report-links', 'rabotayushchie-kampanii-bez-klikov', 'Работающие кампании без кликов'),
                url: this._reportUrl(5)
            });

            !this.params.isMedia && items.push({
                text: iget2('b-report-links', 'ostanovlennye-kampanii-na-kotoryh', 'Остановленные кампании, на которых есть деньги'),
                url: this._reportUrl(6)
            });

            return items;
        },

        _newPopupContent: function() {
            var list = this._getLinks().map(function(item) {
                return {
                    elem: 'item',
                    content: {
                        block: 'link',
                        mix: [{ block: 'b-report-links', elem: 'link' }],
                        content: item.text,
                        url: item.url
                    }
                };
            });

            this._getPopup().setContent(BEMHTML.apply({
                block: 'b-list',
                content: {
                    elem: 'list',
                    content: list
                }
            }));
        },

        _openPopup: function(domElem) {
            var login = this.elemParams(domElem).login;

            this._ulogin = login ? { ulogin: login } : {};
            this._prevButton == domElem[0] || this._newPopupContent();
            this._prevButton = domElem[0];
            this._getPopup().toggle(domElem);
        }

    }, {

        live: function() {
            this.liveBindTo('toggle', 'click', function(e) {
                this._openPopup(e.data.domElem);
            })
        }

    })

})();
