block('b-report-ready')(

    content()(function() {
        return iget2('b-report-ready', 'net-gotovyh-otchetov', 'Нет готовых отчетов');
    }),

    match(function() {
        return !!(this.ctx.reports && this.ctx.reports.length);
    }).content()(function() {
        var data = this.data,
            form = data.FORM,
            ulogin = form.ulogin,
            lang = data.lang,
            url = u.parseUrl(data.url),
            currentPage = data.page,
            totalPages = data.pages_num;

        return [
            {
                block: 'b-data-table',
                sortBy: 'create_time',
                reverse: form.reverse,
                mix: [
                    {
                        block: 'b-style-table',
                        mods: {
                            theme: 'gray-list'
                        }
                    },
                    {
                        block: 'b-report-ready',
                        elem: 'table'
                    }
                ],
                columns: [
                    {
                        key: 'create_time',
                        title: iget2('b-report-ready', 'sozdan', 'Создан')
                    },
                    {
                        key: 'report_name',
                        title: iget2('b-report-ready', 'dannye', 'Данные'),
                        transformData: function(row) {
                            return '&laquo;' + row.report_name + '&raquo;';
                        }
                    },
                    {
                        key: 'period',
                        title: iget2('b-report-ready', 'period', 'Период'),
                        transformData: function(row) {
                            var from = row.date_from && new Date(row.date_from),
                                to = row.date_to && new Date(row.date_to),
                                period = '',
                                months = [
                                    iget2('b-report-ready', 'yanvarya', 'января'), iget2('b-report-ready', 'fevralya', 'февраля'), iget2('b-report-ready', 'marta', 'марта'), iget2('b-report-ready', 'aprelya', 'апреля'), iget2('b-report-ready', 'maya', 'мая'),
                                    iget2('b-report-ready', 'iyunya', 'июня'), iget2('b-report-ready', 'iyulya', 'июля'), iget2('b-report-ready', 'avgusta', 'августа'), iget2('b-report-ready', 'sentyabrya', 'сентября'), iget2('b-report-ready', 'oktyabrya', 'октября'),
                                    iget2('b-report-ready', 'noyabrya', 'ноября'), iget2('b-report-ready', 'dekabrya', 'декабря')
                                ],

                                formatDate = function(date) {
                                    return date.getDate() + ' ' + months[date.getMonth()] + ' ' +
                                        (date.getYear() + 1900);
                                };

                            // интервал
                            if (from && to) {
                                if (from.getYear() === to.getYear()) {
                                    if (from.getMonth() === to.getMonth()) {
                                        if (from.getDate() !== to.getDate()) {
                                            period = from.getDate();
                                        }
                                    } else {
                                        period = from.getDate() + ' ' + months[from.getMonth()];
                                    }
                                } else {
                                    period = formatDate(from);
                                }
                                period = period + (period ? ' – ' : '') + formatDate(to);
                            } else if (from) {
                                period = iget2('b-report-ready', 's-s', 'с {foo}', {
                                    foo: formatDate(from)
                                });
                            } else if (to) {
                                period = iget2('b-report-ready', 'po-s', 'по {foo}', {
                                    foo: formatDate(to)
                                });
                            } else {
                                period = iget2('b-report-ready', 'ves-period', 'Весь период');
                            }

                            return period;
                        }
                    },
                    {
                        key: 'status',
                        title: iget2('b-report-ready', 'deystviya', 'Действия'),
                        transformData: function(row) {
                            var removeLinkCtx = !row.no_delete && {
                                block: 'link',
                                mods: {
                                    'need-confirm': 'yes'
                                },
                                confirm: iget2('b-report-ready', 'vy-uvereny-chto-hotite', 'Вы уверены, что хотите удалить отчет?'),
                                url: u.formatUrl({
                                    protocol: url.protocol,
                                    host: url.host,
                                    path: url.path,
                                    query: {
                                        cmd: 'delPdfReport',
                                        rid: row.id,
                                        type: row.type,
                                        ulogin: ulogin,
                                        retpath: data.current_url
                                    }
                                }),
                                content: iget2('b-report-ready', 'udalit-101', 'удалить')
                            };

                            if (row.status_no_data === 'Yes') {
                                return [
                                    iget2('b-report-ready', 'net-dannyh-br-za', 'Нет данных<br/>за&nbsp;выбранный период'),
                                    '<br />',
                                    removeLinkCtx
                                ];

                            } else if (+row.is_fail) {
                                return [
                                    iget2('b-report-ready', 'oshibka-generacii', 'Ошибка генерации'),
                                    '<br/>',
                                    {
                                        block: 'link',
                                        url: u.formatUrl({
                                            protocol: url.protocol,
                                            host: url.host,
                                            path: url.path,
                                            query: {
                                                cmd: 'repairPdfReport',
                                                rid: row.id,
                                                type: row.type,
                                                ulogin: ulogin
                                            }
                                        }),
                                        content: iget2('b-report-ready', 'povtorit', 'повторить')
                                    },
                                    '&nbsp;',
                                    removeLinkCtx && u._.extend(removeLinkCtx, {
                                        content: iget2('b-report-ready', 'otmenit', 'отменить')
                                    })
                                ];
                            } else if (row.status === 'ready' || row.status === 'opened') {
                                var res = [],

                                    // строит ссылку для скачивания отчета (части отчета)
                                    getDownloadLinkCtx = function(part) {
                                        var cidsUrlPart = row.cids.match(/^\d+$/) ?
                                                row.cids.match(/(\d+)/g).join('_') + '_' :
                                                '',
                                            // форматирование даты в path
                                            formatDate = function(dateStr) {
                                                if (!dateStr) return '';

                                                var date = new Date(dateStr);

                                                return date.getDate() + date.getMonth() + (date.getYear() + 1900);
                                            },
                                            path = '/registered/yadirect_' + cidsUrlPart + 'report_' +
                                                formatDate(row.date_from) + '-' + formatDate(row.date_to) +
                                                    (part ? '.part' + part : '') + '.' +
                                                        (row.type === 'pdf' ? 'pdf' : row.file_type),
                                            query = {
                                                cmd: 'loadPdfReport',
                                                rid: row.id,
                                                type: row.type,
                                                file_type: row.file_type,
                                                ulogin: ulogin
                                            };

                                        part && (query.part_id = part);

                                        return {
                                            block: 'link',
                                            url: u.formatUrl({
                                                path: path,
                                                query: query
                                            }),
                                            content: part ? part : iget2('b-report-ready', 'skachat', 'скачать')
                                        };
                                    };

                                if (row.parts_qty > 1) {
                                    res.push(iget2('b-report-ready', 'skachat', 'скачать'), '&nbsp;');
                                    row.parts_qty.forEach(function(part, n) {
                                        res.push(getDownloadLinkCtx(n));
                                    });
                                } else {
                                    res.push(getDownloadLinkCtx());
                                }

                                res.push('&nbsp;', removeLinkCtx, '&nbsp;');

                                // для английского языка выводится ссылка еще одна
                                lang === 'en' && res.push('<br />', {
                                    block: 'link',
                                    attrs: {
                                        target: '_blank'
                                    },
                                    url: '/pdf_reports/Appendix.pdf',
                                    content: iget2('b-report-ready', 'download-appendix', 'download Appendix')
                                });

                                return res;

                            } else {
                                return iget2('b-report-ready', 'v-processe-br-podgotovki', 'в процессе<br/>подготовки...');
                            }

                        }
                    }
                ],
                mixes: {
                    row: [{
                        block: 'b-style-table',
                        elem: 'row'
                    }],
                    headerRow: [
                        {
                            block: 'b-style-table',
                            elem: 'head'
                        },
                        {
                            block: 'b-report-ready',
                            elem: 'head'
                        }
                    ],
                    cell: [
                        {
                            block: 'b-style-table',
                            elem: 'cell'
                        },
                        {
                            block: 'b-report-ready',
                            elem: 'cell'
                        }
                    ],
                    headerCell: function(key) {

                        return [
                            {
                                block: 'b-style-table',
                                elem: 'cell'
                            },
                            {
                                block: 'b-report-ready',
                                elem: key.replace('_', '-') + '-column'
                            }
                        ];
                    }
                },
                rows: this.ctx.reports || []
            },
            totalPages > 1 && {
                block: 'b-pager',
                mix: [{
                    block: 'b-report-ready',
                    elem: 'pager'
                }],
                currentPage: currentPage,
                totalPages: totalPages,
                pageParam: 'page',
                startFrom: 1,
                pageUrl: u.formatUrl({
                    protocol: url.protocol,
                    host: url.host,
                    path: url.path,
                    query: {
                        cmd: 'listOfflineReports',
                        cid: data.cid,
                        target_all: +form.target_all,
                        ncrnd: form.ncrnd,
                        ulogin: ulogin
                    }
                }),
                content: [
                    {
                        elem: 'button-prev',
                        content: '←&nbsp;' + iget2('b-report-ready', 'predydushchaya', 'предыдущая')
                    },
                    {
                        elem: 'button-next',
                        content: iget2('b-report-ready', 'sleduyushchaya', 'следующая') + '&nbsp;→'
                    },
                    {
                        elem: 'pages'
                    }
                ]
            }
        ];
    })
);
