/**
 * Редактирование условия подбора аудитории
 * Оборачивает в popup блок из bricks
 *
 * @param {?Number} ctx.conditionId                 // редактируемая запись
 * @param {Boolean} ctx.showBtnSaveAsNew            // показать кнопку "сохранить как"
 * @namespace b-retargeting-condition-edit-popup
 */
block('b-retargeting-condition-edit-popup')(

    js()(function() {
        return {
            isExist: !!this.ctx.conditionId
        }
    }),

    content()(function() {
        var ctx = this.ctx,
            isExist = !!(ctx.conditionId);

        return [
            {
                block: this.block,
                elem: 'header',
                name: isExist ? iget2(
                    'b-retargeting-condition-edit-popup',
                    'redaktirovanie-usloviya-podbora-auditorii',
                    'Редактирование условия подбора аудитории'
                ) : iget2('b-retargeting-condition-edit-popup', 'novoe-uslovie-podbora-auditorii', 'Новое условие подбора аудитории')
            },
            {
                elem: 'body',
                mix: {
                    block: 'b-modal-popup-decorator',
                    elem: 'body'
                },
                content: {
                    block: 'b-retargeting-condition-wizard',
                    conditionId: ctx.conditionId
                }
            },
            {
                block: this.block,
                elem: 'footer',
                saveAsNew: isExist && ctx.showBtnSaveAsNew
            }
        ];
    })
);
