block('b-retargeting-empty').content()(function() {
    var ctx = this.ctx;

    return [
        {
            elem: 'head',
            tag: 'h3',
            content: iget2('b-retargeting-empty', 'nechego-dobavit', 'Нечего добавить.')
        },
        {
            elem: 'info',
            content: iget2(
                'b-retargeting-empty',
                'u-vas-ne-opredelena',
                'У вас не определена ни одна цель в Яндекс.Метрике. Пожалуйста, {create}, или, если цели созданы на счётчиках другого логина, {access}',
                {
                    create: function(text) {
                        return {
                            block: 'link',
                            target: 'blank',
                            url: u.getMetrikaUrl('list'),
                            content: text
                        }
                    }(iget2('b-retargeting-empty', 'u-vas-ne-opredelena-param-create', 'создайте цели')),

                    access: function(text) {
                        return {
                            block: 'link',
                            target: 'blank',
                            url: u.getUrl('requestAccessToMetrikaCounters', {
                                ulogin: ctx.ulogin
                            }),
                            content: text
                        }
                    }(iget2('b-retargeting-empty', 'u-vas-ne-opredelena-param-access', 'получите к ним доступ.')),

                    context: 'create - создайте цели; access - получите к ним доступ.'
                }
            )
        },
        {
            elem: 'more',
            content: {
                block: 'link',
                target: 'blank',
                url: u.getCommonHelpUrl('/metrika?id=1036908'),
                content: iget2('b-retargeting-empty', 'podrobnee-o-yandeks-metrike', 'Подробнее о Яндекс.Метрике и целях')
            }
        }
    ];
});
