block('b-retargetings-data')(
    def()(function() {
        var allRetargetingConditionsFiltered = {};

        u._.forEach(this.data.all_retargeting_conditions, function(cond, key) {
            var hasYaAudience = u._.some(cond.condition, function(group) {
                return u._.some(group.goals, function(goal) {
                    return goal.goal_type === 'audience';
                });
            });

            (!hasYaAudience || u.consts('is_audience_enabled')) && (allRetargetingConditionsFiltered[key] = cond);
        });

        this.data.all_retargeting_conditions = allRetargetingConditionsFiltered;

        return applyNext();
    }),

    addJs()(function() {
        return {
            conditionIds: Object.keys(
                u.retargeting.filterConditionsByType(this.data.all_retargeting_conditions, 'metrika_goals')
            ).map(function(key) {
                return this.data.all_retargeting_conditions[key].ret_cond_id;
            }, this)
        };
    }),

    content()(function() {
        return [
            {
                block: 'i-model-aggregator',
                content: Object.keys(
                        u.retargeting.filterConditionsByType(this.data.all_retargeting_conditions, 'metrika_goals')
                ).map(function(key) {
                    var cond = this.data.all_retargeting_conditions[key];

                    return {
                        block: 'i-model',
                        modelParams: {
                            name: 'm-retargeting-condition',
                            id: cond.ret_cond_id,
                            data: {
                                ret_cond_id: cond.ret_cond_id,
                                condition_name: cond.condition_name,
                                condition_desc: cond.condition_desc,
                                is_accessible: cond.is_accessible,
                                is_negative: cond.properties === 'negative',
                                campaigns: (cond.campaigns || []).map(function(camp) {
                                    return {
                                        cid: camp.cid,
                                        name: camp.name,
                                        url: u.getUrl('showCamp', {
                                            cid: camp.cid,
                                            ulogin: u.consts('ulogin')
                                        })
                                    };
                                }),
                                clicks: cond.ctx_clicks || 0,
                                shows: cond.ctx_shows || 0,
                                ctr: cond.ctx_ctr || '0.00',
                                groups: cond.condition.map(function(group) {
                                    return {
                                        type: group.type,
                                        goals: group.goals.map(function(goal) {
                                            return {
                                                id: goal.goal_id,
                                                time: goal.time,
                                                //todo - пока не приходит goal_type
                                                //тикет на серверсайд - DIRECT-53726
                                                goalType: goal.goal_type || 'goal'
                                            };
                                        })
                                    };
                                })
                            }
                        }
                    };
                }, this)
            }
        ];
    })
);
