(function() {

    var goalTypeTitles = {
            audience: iget2('b-retargetings-data', 'segment-auditoriy', 'Сегмент Аудиторий'),
            goal: iget2('b-retargetings-data', 'cel-metriki', 'Цель Метрики'),
            segment: iget2('b-retargetings-data', 'segment-metriki', 'Сегмент Метрики')
        },
        goalTypeHints = {
            audience: iget2('b-retargetings-data', 'nayti-segment', 'Найти сегмент'),
            goal: iget2('b-retargetings-data', 'nayti-cel', 'Найти цель'),
            segment: iget2('b-retargetings-data', 'nayti-segment', 'Найти сегмент')
        },
        goalTypeEmptyText = {
            audience: iget2('b-retargetings-data', 'net-segmentov-sootvetstvuyushchih-filtru', 'Нет сегментов, соответствующих фильтру'),
            goal: iget2('b-retargetings-data', 'net-celey-sootvetstvuyushchih-filtru', 'Нет целей, соответствующих фильтру'),
            segment: iget2('b-retargetings-data', 'net-segmentov-sootvetstvuyushchih-filtru', 'Нет сегментов, соответствующих фильтру')
        },
        goalTypeEmpyNameText = {
            audience: iget2('b-retargetings-data', 'segment-ne-nayden', 'Сегмент не найден'),
            goal: iget2('b-retargetings-data', 'cel-ne-naydena', 'Цель не найдена'),
            segment: iget2('b-retargetings-data', 'segment-ne-nayden', 'Сегмент не найден')
        },
        getSortKey = function(type, hasGoals) {
            return (hasGoals ? '1' : '0') +
                (type === 'audience' ? '0' : '1') +
                (type === 'goal' ? '1' : '0');
        };

    u.register({
        'b-retargetings-data': {

            /**
             * Возвращает список заголовков для выбора типа цели/сегмента в зависимости от того, какие цели/сегменты
             * доступны
             * @param {Object} goals
             * @returns {Array}
             */
            getGoalsTypesList: function(goals) {
                return Object.keys(goals.lists).sort(function(type1, type2) {
                    var key1 = getSortKey(type1, !!goals.lists[type1]
                            .filter(function(goal) { return goal.allow }).length),
                        key2 = getSortKey(type2, !!goals.lists[type2]
                            .filter(function(goal) { return goal.allow }).length);

                    return key1 < key2 ? 1 : (key1 > key2 ? -1 : 0);
                });
            },

            /**
             * Возвращает название для соответствующего типа цели/сегмента
             * @param {'audience'|'goal'|'segment'} goalType
             * @returns {String}
             */
            getGoalTypeTitle: function(goalType) {
                return goalTypeTitles[goalType];
            },

            /**
             * Возвращает хинт для поиска по целями/сегментам в селекте выбора
             * @param {'audience'|'goal'|'segment'} goalType
             * @returns {String}
             */
            getSearchHint: function(goalType) {
                return goalTypeHints[goalType];
            },

            /**
             * Возвращает текст о том, что цель/сегмент не найдены
             * @param {'audience'|'goal'|'segment'} goalType
             * @returns {String}
             */
            goalTypeEmptyText: function(goalType) {
                return goalTypeEmptyText[goalType];
            },

            /**
             * Доступна ли данная цель
             * @param {String} goalId
             * @param {Object} allClientGoals
             * @returns {Boolean}
             */
            isGoalAvailable: function(goalId, allClientGoals) {
                return allClientGoals.available.indexOf(+goalId) !== -1;
            },

            /**
             * Есть ли доступные цели в списке с целями
             * @param {Object} allClientGoals
             * @returns {Boolean}
             */
            hasAvailableGoals: function(allClientGoals) {
                return !!allClientGoals.available.length;
            },

            /**
             * Есть ли  недоступные цели в списке с целями
             * @param {Object} allClientGoals
             * @returns {Boolean}
             */
            hasNotAvailableGoals: function(allClientGoals) {
                return !!allClientGoals.notAvailable.length;
            },

            /**
             * Возвращает список целей/сегментов для данного типа
             * @param {String} goalsType
             * @param {Object} allClientGoals
             * @returns {Array}
             */
            getGoalsListByType: function(goalsType, allClientGoals) {
                return allClientGoals.lists[goalsType];
            },

            /**
             * Находит цель по ее id
             * @param {String} goalId
             * @param {Object} allClientGoals
             * @returns {Object}
             */
            getGoalById: function(goalId, allClientGoals) {
                return allClientGoals.hash[goalId];
            },

            /**
             * Возвращает первую цель в списке заданного типа
             * @param {String} goalsType
             * @param {Object} allClientGoals
             * @returns {Object}
             */
            getFirstGoalInListByType: function(goalsType, allClientGoals) {
                var goalsList = this.getGoalsListByType(goalsType, allClientGoals);

                if (!goalsList.length) {
                    //случай когда нет целей/сегментов данного типа
                    return {
                        goalType: goalsType
                    }
                } else {
                    if (!goalsList[0].allow) {
                        //случай когда есть только недоступные цели/сегменты данного типа
                        return {
                            goalType: goalsType
                        };
                    }

                    return goalsList[0];
                }
            },

            /**
             *
             * @param {String} goalId
             * @param {Object} allClientGoals
             * @returns {String}
             */
            getGoalName: function(goalId, allClientGoals) {
                var goal = allClientGoals.hash[+goalId];

                if (!goal.allow && !goal.name) {
                    goal.name = goalTypeEmpyNameText[goal.goalType];
                }

                return (goal.domain ? goal.domain + ' ::&nbsp;' : '') + u.escapeHTML(goal.name);
            },

            /**
             *
             * @param {Object} allClientGoals
             * @returns {Array}
             */
            getAvailableGoalsList: function(allClientGoals) {
                return allClientGoals.available.map(function(id) {
                    return this.getGoalById(+id, allClientGoals);
                }, this)
            },

            getConditionDomainsList: function(condition, allClientGoals) {
                var hasSegment = false,
                    domains = [];

                if (!allClientGoals) {
                    return domains;
                }

                condition.groups.forEach(function(group) {
                    group.goals.forEach(function(goal) {
                        var clientGoal = u['b-retargetings-data'].getGoalById(goal.id, allClientGoals) || {};

                        if (clientGoal.domain && domains.indexOf(clientGoal.domain) === -1) {
                            domains.push(clientGoal.domain);
                        }

                        // DIRECT-53373 цели Я.Аудитории
                        if (!hasSegment && clientGoal.goalType === 'audience' && clientGoal.allow) {
                            domains.push('audience.yandex.' + u.consts('tld'));
                            hasSegment = true;
                        }
                    }, this);
                }, this);

                return domains;
            },

            /**
             * Возвращает флаг, определяющий содержит ли условие сегменты Аудитории с типом "гео"
             * @param {Object} condition условие ретаргетинга
             * @param {Array} allClientGoals список целей метрики
             * @returns {Boolean}
             */
            isConditionWithGeoSegment: function(condition, allClientGoals) {
                var hasGeoSegment = false,
                    geoGoalTypes = ['geo_last', 'geo_regular', 'geo_condition'];

                if (!allClientGoals) {
                    return hasGeoSegment;
                }

                condition.groups.forEach(function(group) {
                    group.goals.forEach(function(goal) {
                        var clientGoal = this.getGoalById(goal.id, allClientGoals) || {};

                        if (clientGoal.goalSubType && geoGoalTypes.indexOf(clientGoal.goalSubType) !== -1) {
                            hasGeoSegment = true;
                        }
                    }, this);
                }, this);

                return hasGeoSegment;
            },

            /**
             * Формируем из данных о целях метрики, пришедших с сервера объект, с которым будем дальше работать
             * @param {Object[]} goalList
             * @returns {Object}
             */
            formatGoalList: function(goalList) {
                var types = ['goal', 'segment'],
                    goals = {
                        lists: {},
                        available: [],
                        notAvailable: [],
                        hash: {}
                    };

                if (u.consts('is_audience_enabled')) {
                    types.push('audience');
                }

                if (u.consts('isLalSegmentsEnabled')) {
                    types.push('lal_segment');
                }

                if (u.hasClientFeature('in_app_mobile_targeting')) {
                    types.push('mobile');
                }

                types.forEach(function(type) {
                    goals.lists[type] = [];
                });

                goalList.forEach(function(goalDetails) {
                    var id = goalDetails.id,
                        goal = {
                            id: id,
                            name: goalDetails.name,
                            goalType: goalDetails.type,
                            goalSubType: goalDetails.subtype,
                            counterId: goalDetails.counter_id || goalDetails.mobile_app_id,
                            allow: goalDetails.allow_to_use,
                            domain: goalDetails.domain || goalDetails.mobile_app_name
                        };

                    if (!goals.lists[goal.goalType]) return;

                    goals.lists[goal.goalType].push(goal);

                    goal.allow ?
                        goals.available.push(id) :
                        goals.notAvailable.push(id);

                    goals.hash[id] = goal;
                });

                //сортируем, смещая недоступные сегменты/цели вниз списка
                types.forEach(function(type) {
                    goals.lists[type].sort(function(one, other) {
                        if (one.allow == other.allow) return 0;

                        if (one.allow) return -1;

                        return 1;
                    });
                });

                return goals;
            },

            mapResponseConditionToModel: function(condition) {
                return {
                    ret_cond_id: condition.id,
                    condition_desc: condition.description,
                    condition_name: condition.name,
                    is_accessible: condition.is_accessible,
                    is_negative: condition.is_negative,
                    domains: condition.domains,
                    groups: condition.conditions.map(function(groupRule) {
                        return {
                            type: groupRule.type,
                            goals: groupRule.goals.map(function(goal) {
                                return {
                                    goalType: goal.type,
                                    time: goal.day,
                                    id: goal.id
                                };
                            })
                        }
                    })
                }
            }

        }
    });

})();
