BEM.DOM.decl('b-rotate-buttons', {

    /**
     * Хэш кнопок навигации
     */
    _buttons: null,

    /**
     * Размер ротации
     */
    _size: -1,

    /**
     * Позиция в ротации
     */
    _position: 0,

    onSetMod: {
        js: function() {
            this._buttons = {};

            ['back', 'next'].forEach(function(elem) {
                this._buttons[elem] = this.findBlockOn(elem, 'button');

                this._buttons[elem].on('click', function() { this._walk(elem) }, this);
            }, this);
        },
        disabled: function(modName, modValue) {
            if (this._size < 0) {
                ['back', 'next'].forEach(function(elem) {
                    this._buttons[elem].setMod(modName, modValue);
                }, this);
            } else {
                this.afterCurrentEvent(this._checkBorders, this);
            }
        }
    },

    /**
     * Пройти назад
     */
    goBack: function() {
        this._walk('back');
    },

    /**
     * Пройти вперед
     */
    goNext: function() {
        this._walk('next');
    },

    /**
     * Задает размер ротации
     * Для сброса ограничения по размеру нужно передать size
     * равный -1, тогда ротация будет циклической
     * @param {Number} size
     * @param {Number} position - номер позиции
     */
    setSize: function(size, position) {
        this._size = size;
        this._position = position || 0;

        this._checkBorders();
    },

    /**
     * Пройти вперед/назад
     * @param {String} where направление back или next
     * @private
     */
    _walk: function(where) {
        this.trigger(where);

        this._size > -1 && this._checkBorders(where === 'back' ? -1 : 1);
    },

    /**
     * Блокировка кнопок при заданном размере ротации
     * @param {Number} [val]
     * @private
     */
    _checkBorders: function(val) {
        var isBlockDisabled = this.hasMod('disabled', 'yes'),
            newPosition = this._position + (val || 0),
            sized = this._size > -1,
            disabled = {
                back: isBlockDisabled || (sized ? newPosition <= 0 : false),
                next: isBlockDisabled || (sized ? newPosition >= this._size - 1 : false)
            };

        ['back', 'next'].forEach(function(elem) {
            this._buttons[elem].setMod('disabled', disabled[elem] ? 'yes' : '');
        }, this);

        if (-1 < newPosition && newPosition < this._size) {
            this._position = newPosition;
        }
    }

});
