BEM.DOM.decl('b-save-settings', {

    onSetMod: {

        js: function() {

            this.customFilters = this.params.customFilters || {};

            this.findBlockOn('add', 'button').on('click', this._saveSettings, this);

            this._bindEvents();

        }
    },

    /**
     * Подписывает контролы на события
     * @private
     */
    _bindEvents: function() {
        this.bindTo(this.findElem('set'), 'click', this._setSettings);

        this.bindTo(this.findElem('delete'), 'click', this._deleteSettings);

    },

    /**
     * Возвращает модель формы статистики
     * @returns {*|_model}
     * @private
     */
    _getModel: function() {
        if (!this._model) this._model = BEM.MODEL.getOne('m-custom-stat');

        return this._model;
    },

    /**
     * Удаляет фильтр и отправляет обновленный список фильтров на сервер
     * @param {jQuery.event} e
     * @private
     */
    _deleteSettings: function(e) {
        e.preventDefault();

        var settingName = this.elemParams($(e.currentTarget)).settingName;

        delete this.customFilters[settingName];

        this._syncSettings();
    },

    /**
     * Добавляет текущие настройки в список фильтров, загружает их на сервер
     * @private
     */
    _saveSettings: function() {

        var input = this.findBlockInside('input'),
            ruleName = input.val(),
            model = this._getModel(),
            customFilters = this.customFilters;

        if (!ruleName) {
            alert(iget2('b-save-settings', 'vvedite-nazvanie-shablona', 'Введите название шаблона!'));

            return;
        } else if (Object.keys(customFilters).length >= 5) {
            alert(iget2(
                'b-save-settings',
                'u-vas-uzhe-est',
                'У Вас уже есть 5 сохраненных шаблонов. Удалите один из них, если хотите сохранить новый.'
            ));

            return;
        } else if (ruleName in customFilters) {
            alert(iget2('b-save-settings', 'u-vas-uzhe-est-119', 'У Вас уже есть шаблон с таким названием.'));

            return;
        }

        customFilters[ruleName] = model.toJSON();

        input.val('');

        this._syncSettings();

    },

    /**
     * Загружает фильтры на сервер
     * @private
     */
    _syncSettings: function() {
        BEM.create('i-request_type_ajax', {
            url: '/registered/main.pl',
            dataType: 'json',
            cache: false,
            callbackCtx: this,
            type: 'POST'
        }).get(
            {
                cmd: 'ajaxUserOptions',
                csrf_token: this.params.csrfToken,
                custom_filters: JSON.stringify(this.customFilters)
            },
            function(data) {
                this.customFilters = JSON.parse(data.custom_filters);

                BEM.DOM.update(
                    this.elem('menu'),
                    BEMHTML.apply({
                        block: 'b-save-settings',
                        elem: 'menu',
                        customFilters: this.customFilters
                    }),
                    this._bindEvents,
                    this);
            }
        );
    },

    /**
     * Устанавливает настройки из фильтра в модель
     * @param {jQuery.event} e
     * @private
     */
    _setSettings: function(e) {
        e.preventDefault();

        var settingName = this.elemParams($(e.currentTarget)).settingName,
            model = this._getModel();

        [
            'tag', 'filter_tag', 'adgroup', 'filter_adgroup', 'avg_position',
            'banner', 'filter_banner', 'page', 'filter_page_target',
            'use_page_id', 'filter_page', 'phrase', 'filter_phrase',
            'retargeting', 'filter_retargeting', 'dynamic', 'filter_dynamic',
            'geo', 'filter_geo', 'position', 'filter_position', 'image', 'filter_image',
            'date', 'group', 'device_type', 'filter_device_type', 'with_auto_added_phrases',
            'age', 'filter_age', 'gender', 'filter_gender', 'performance_filter', 'filter_performance_filter',
            'connection_type', 'filter_connection_type', 'detailed_device_type', 'filter_detailed_device_type'
        ].forEach(function(field) {
            model.set(field, this.customFilters[settingName][field]);
        }, this);
    }
});
