block('b-search-form')(

    def()(function() {
        return applyNext({
            _ctx: this.ctx
        });
    }),

    content()(function() {
        return {
            elem: 'form',
            attrs: {
                action: this.ctx.action || '',
                method: this.ctx.method || 'get'
            }
        };
    }),

    elem('form').content()(function() {
        var res = [{
            elem: 'header',
            content: this._ctx.title
        }];

        this._ctx.inputs && this._ctx.inputs.forEach(function(i) {
            res.push({
                elem: 'param',
                mix: [{
                    block: 'i-clearfix'
                }],
                content: [
                    i.label && {
                        elem: 'label',
                        content: i.label.content + ':',
                        attrs: i.label.id && {
                            for: i.label.id
                        }
                    },
                    i.input && {
                        elem: 'input',
                        content: i.input
                    }
                ]
            });
        });

        this._ctx.hiddenInputs && this._ctx.hiddenInputs.forEach(function(i) {
            res.push({
                elem: 'hidden-input',
                attrs: {
                    type: 'hidden',
                    name: i.name,
                    value: i.value
                }
            });
        });

        res.push({
            elem: 'button-container',
            content: {
                block: 'button',
                type: 'submit',
                content: iget2('b-search-form', 'nayti', 'Найти')
            }
        });

        return res;
    })
);
