block('b-search-useful-links')(

    elem('list').replace()(function() {
        var ctx = this.ctx,
            items = ctx.items;

        if (!items || !items.length) {
            return '';
        }

        return {
            block: 'b-list',
            content: [
                ctx.category && {
                    elem: 'header',
                    content: ctx.category + ':'
                },
                {
                    elem: 'list',
                    content: ctx.items.map(function(item) {
                        return item && {
                            elem: 'item',
                            content: item.content || {
                                block: 'link',
                                url: item.url,
                                content: item.text
                            }
                        };
                    })
                }
            ]
        };
    }),

    elem('left')(

        def()(function() {
            return applyNext({
                manager: this.data.login_rights.manager_control,
                permission: this.data.login_rights,
                role: this.data.login_rights.role
            });
        }),

        mode('nonCategorizedLinks')(function() {
            var items = [],
                pm = this.permission;

            pm.ShowOfferToServicing && this.role != 'placer' && this.role != 'media' && items.push({
                text: iget2('b-search-useful-links', 'spisok-kampaniy-dlya-priema', 'Список кампаний для приема на обслуживание менеджером'),
                url: u.getUrl('showOfferToServicing')
            });

            pm.FirstAid && pm.SystemReport && items.push({
                text: iget2('b-search-useful-links', 'zayavki-na-pervuyu-i', 'Заявки на Первую и Вторую помощи'),
                url: u.getUrl('listOptimize')
            });

            pm.support_control && pm.UnServicingCamp && items.push({
                text: iget2('b-search-useful-links', 'snyat-kampaniyu-s-obsluzhivaniya', 'Снять кампанию с обслуживания менеджером'),
                url: u.getUrl('unServicingCamp')
            });

            return {
                elem: 'list',
                items: items
            };
        }),

        mode('generalLinks')(function() {
            var items = [],
                pm = this.permission;

            (pm.superreader_control || pm.support_control) && items.push({
                text: iget2('b-search-useful-links', 'sozdanie-oprosa-klientov', 'Создание опроса клиентов'),
                url: u.getUrl('manageSurveys')
            });

            (this.role != 'placer') && items.push({
                text: iget2('b-search-useful-links', 'ocenka-byudzheta-reklamnoy-kampanii', 'Оценка бюджета рекламной кампании'),
                url: u.getUrl('advancedForecast')
            });

            if (!hasLoginRights('is_super_manager')) {

                pm.CheckMirrors && items.push({
                    text: iget2('b-search-useful-links', 'proverka-ssylok-po-baze', 'Проверка ссылок (по базе зеркал)'),
                    url: u.getUrl('checkMirrors')
                });

                pm.EditMirrors && items.push({
                    text: iget2('b-search-useful-links', 'korrekciya-bazy-zerkal', 'Коррекция базы зеркал'),
                    url: u.getUrl('editMirrors')
                });

                pm.GetSuggestion && items.push({
                    text: iget2('b-search-useful-links', 'podskazki', 'Подсказки'),
                    url: u.getUrl('getSuggestPhrases')
                });
            }

            (pm.super_control || pm.manager_control || pm.placer_control ||
             pm.support_control || pm.limited_support_control) && items.push({
                 text: iget2('b-search-useful-links', 'skopirovat-kampaniyu', 'Скопировать кампанию'),
                 url: u.getUrl('copyCamp')
             });

            hasLoginRights('super_control', 'support_control', 'placer_control') && items.push({
                text: iget2('b-search-useful-links', 'optovaya-blokirovka-spam-loginov', 'Оптовая блокировка спам-логинов'),
                url: u.getUrl('massBlockUsers', {
                    csrf_token: u.consts('csrf_token')
                })
            });

            return {
                elem: 'list',
                category: iget2('b-search-useful-links', 'obshchee', 'Общее'),
                items: items
            };
        }),

        mode('historyLinks')(function() {
            var items = [],
                pm = this.permission;

            pm.ShowAccessLogs && items.push({
                text: iget2('b-search-useful-links', 'prosmotr-logov', 'Просмотр логов'),
                url: u.getUrl('showLogs')
            });

            if (pm.ShowLogs) {
                items.push({
                    text: iget2('b-search-useful-links', 'prosmotr-logov-balansa', 'Просмотр логов баланса'),
                    url: u.getUrl('showBalanceLogs')
                }, {
                    text: iget2('b-search-useful-links', 'prosmotr-logov-pisem', 'Просмотр логов писем'),
                    url: u.getUrl('showMailLogs')
                }, {
                    text: iget2('b-search-useful-links', 'prosmotr-logov-sms', 'Просмотр логов SMS'),
                    url: u.getUrl('showSmsLogs')
                }, {
                    text: iget2('b-search-useful-links', 'prosmotr-logov-sobytiy', 'Просмотр логов событий'),
                    url: u.getUrl('internalReports', {
                        report_id: 'search_eventlog'
                    })
                });
            }

            return {
                elem: 'list',
                category: iget2('b-search-useful-links', 'prosmotr-istorii', 'Просмотр истории'),
                items: items
            };
        }),

        content()(

            match(function() {
                return !this.manager;
            })(function() {
                return [

                    apply('nonCategorizedLinks'),

                    apply('generalLinks'),

                    (this.permission.ShowAccessLogs || this.permission.ShowLogs) &&
                    (!hasLoginRights('is_super_manager')) &&
                    (!this.permission.media_control || this.permission.is_super_media_planner) &&
                            apply('historyLinks'),

                    {
                        elem: 'list',
                        items: [
                            (!hasLoginRights('is_super_manager')) && (this.permission.super_control ||
                                this.permission.support_control ||
                                this.permission.limited_support_control ||
                                this.permission.superreader_control) && {
                                    text: iget2('b-search-useful-links', 'kogda-na-kampanii-byli', 'Когда на кампании были деньги'),
                                    url: u.getUrl('internalReports', {
                                        report_id: 'when_money_on_camp_was'
                                    })
                                },
                            this.permission.is_super_media_planner && {
                                text: iget2('b-search-useful-links', 'pakety-fraz-mkb', 'Пакеты фраз МКБ'),
                                url: u.getUrl('mcbThemesList')
                            }
                        ]
                    }
                ];
            }),

            match(function() {
                return this.manager;
            })(function() {
                return {
                    block: 'b-list',
                    mix: [{
                        block: 'b-search-useful-links',
                        elem: 'manager-links'
                    }],
                    content: {
                        block: 'b-layout-table',
                        mods: {
                            layout: '50-50',
                            'auto-columns': '2'
                        },
                        left: {
                            block: 'b-list',
                            elem: 'header',
                            content: iget2('b-search-useful-links', 'eshchyo-poiski', 'Ещё поиски') + ':'
                        },
                        right: {
                            block: 'b-search-useful-links',
                            elem: 'list',
                            items: [
                                {
                                    url: u.getUrl('searchBanners'),
                                    text: iget2('b-search-useful-links', 'poisk-po-banneram', 'Поиск по баннерам')
                                },
                                {
                                    url: u.getUrl('showSearchPage', { by_date: 1 }),
                                    text: iget2('b-search-useful-links', 'rasshirennyy-poisk-kampaniy', 'Расширенный поиск кампаний')
                                }
                            ]
                        }
                    }
                };
            })
        )
    ),

    elem('right')(

        def()(function() {
            return applyNext({
                manager: this.data.login_rights.manager_control,
                permission: this.data.login_rights,
                role: this.data.login_rights.role
            });
        }),

        mode('searchLinks')(function() {
            var items = [];

            this.role.match(/^(super|manager|media|support|superreader)$/) && items.push({
                text: iget2('b-search-useful-links', 'rasshirennyy-poisk-kampaniy', 'Расширенный поиск кампаний'),
                url: u.getUrl('showSearchPage', {
                    by_date: 1
                })
            });

            this.permission.SearchBanner && items.push({
                text: iget2('b-search-useful-links', 'poisk-po-banneram', 'Поиск по баннерам'),
                url: u.getUrl('searchBanners')
            });

            this.permission.placer_control && items.push({
                text: iget2('b-search-useful-links', 'poisk-loginov-po-ip', 'Поиск логинов по IP'),
                url: u.getUrl('internalReports', {
                    report_id: 'search_spam_users'
                })
            });

            this.role.match(/^(super|superreader)$/) && items.push({
                text: iget2('b-search-useful-links', 'internal-ads-search', 'Поиск внутренней рекламы'),
                url: u.getUrl('showInternalAdsSearchPage')
            });

            return {
                elem: 'list',
                category: iget2('b-search-useful-links', 'poisk', 'Поиск'),
                items: items
            };
        }),

        mode('statisticLinks')(function() {
            var items = [],
                pm = this.permission;

            pm.ViewMediaplanStat && items.push({
                text: iget2('b-search-useful-links', 'statistika-po-mediaplanirovaniyu', 'Статистика по медиапланированию'),
                url: u.getUrl('showMediaStat', {
                    type_stat: 'managers'
                })
            });

            return {
                elem: 'list',
                category: iget2('b-search-useful-links', 'statistika', 'Статистика'),
                items: items
            };

        }),

        mode('reportLinks')(function() {
            var items = [],
                pm = this.permission;

            if (pm.manager_control) {
                this.role != 'media' && this.role != 'placer' && items.push({
                    content: {
                        block: 'dropdown',
                        content: [
                            {
                                block: 'link',
                                mix: {
                                    block: 'dropdown',
                                    elem: 'switcher'
                                },
                                mods: {
                                    pseudo: 'yes'
                                },
                                content: iget2('b-search-useful-links', 'otchety-po-kampaniyam', 'Отчеты по кампаниям')
                            },
                            {
                                elem: 'popup',
                                js: {
                                    directions: 'bottom'
                                },
                                mix: {
                                    block: 'b-search-useful-links',
                                    elem: 'campaign-reports-popup'
                                },
                                content: apply('campaignReportLinks')
                            }
                        ]
                    }
                });
            }

            if (!(pm.support_control || pm.limited_support_control)) {
                items.push({
                    text: iget2('b-search-useful-links', 'kampanii-sostoyashchie-tolko-iz', 'Кампании, состоящие только из медиаплана'),
                    url: u.getUrl('getReportMediaCamps')
                });
            }

            if (pm.super_control || pm.manager_control || pm.superreader_control || pm.support_control) {
                !pm.support_control && items.push({
                    text: iget2('b-search-useful-links', 'otchet-po-otklyucheniyam-v', 'Отчет по отключениям в сетях'),
                    url: u.getUrl('reportUncheckedContext')
                });
            }

            if (pm.super_control || pm.superreader_control) {
                items.push({
                    text: iget2('b-search-useful-links', 'kto-takie-fokusirovshchiki', 'Кто такие фокусировщики?'),
                    url: u.getUrl('urlPhrasesDebugPrint')
                });
            }

            if (pm.super_control || pm.superreader_control || pm.limited_support_control) {
                items.push({
                    text: iget2('b-search-useful-links', 'vnutrennie-otchety-indeksnaya-stranica', 'Внутренние отчеты -- индексная страница'),
                    url: u.getUrl('internalReports', {
                        index: 'yes'
                    })
                });
            }

            if (pm.super_control || pm.support_control) {
                items.push({
                    text: iget2('b-search-useful-links', 'spisok-zayavok-na-poluchenie', 'Список заявок на получение доступа к API'),
                    url: u.getUrl('apiCertificationRequestsByDate', {
                        period: 'month',
                        objects_on_page: 10
                    })
                });
            }

            if (hasLoginRights('super_control'))
                items.push({
                    text: iget2('b-search-useful-links', 'raschet-potenciala-klienta', 'Расчёт потенциала клиента'),
                    url: u.getUrl('newClientPotentialReport')
                });

            return {
                elem: 'list',
                category: iget2('b-search-useful-links', 'otchet', 'Отчет'),
                items: items
            };
        }),

        mode('campaignReportLinks')(function() {
            var items = [],
                media = this.permission.media_control,
                uidUrl = this.data.uid_url,
                uidUrlParam = {};

            if (uidUrl && uidUrl.key && uidUrl.value) {
                uidUrlParam[uidUrl.key] = uidUrl.value;
            }

            if (this.permission.manager_control) {
                items.push({
                    text: iget2('b-search-useful-links', 'novye-kampanii-ozhidayushchie-prihoda', 'Новые кампании, ожидающие прихода денег'),
                    url: u.getUrl('getReport', u._.extend({
                        type: 1
                    }, uidUrlParam))
                }, {
                    text: iget2('b-search-useful-links', 'rabotavshie-kampanii-ozhidayushchie-prihoda', 'Работавшие кампании, ожидающие прихода денег'),
                    url: u.getUrl('getReport', u._.extend({
                        type: 2
                    }, uidUrlParam))
                }, {
                    text: iget2('b-search-useful-links', 'zakanchivayushchiesya-kampanii', 'Заканчивающиеся кампании'),
                    url: u.getUrl('getReport', u._.extend({
                        type: 3
                    }, uidUrlParam))
                }, {
                    text: iget2('b-search-useful-links', 'zakonchivshiesya-kampanii-na-kotorye', 'Закончившиеся кампании, на которые не выписан счёт'),
                    url: u.getUrl('getReport', u._.extend({
                        type: 4
                    }, uidUrlParam))
                });
            }

            (!media || this.permission.is_super_media_planner) && items.push({
                text: iget2('b-search-useful-links', 'rabotayushchie-kampanii-bez-klikov', 'Работающие кампании без кликов'),
                url: u.getUrl('getReport', u._.extend({
                    type: 5
                }, uidUrlParam))
            });

            !media && items.push({
                text: iget2('b-search-useful-links', 'ostanovlennye-kampanii-na-kotoryh', 'Остановленные кампании, на которых есть деньги'),
                url: u.getUrl('getReport', u._.extend({
                    type: 6
                }, uidUrlParam))
            });

            return {
                elem: 'list',
                items: items
            };
        }),

        match(function() {
            return !this.manager;
        }).content()(function() {
            return [

                apply('searchLinks'),

                (this.permission.ViewMediaplanStat || this.permission.ViewMediaplan ||
                    this.permission.StatShowRegionalTraffic || this.permission.ShowLogs ||
                    !this.permission.placer_control) && (!hasLoginRights('is_super_manager')) &&
                            apply('statisticLinks'),

                (!hasLoginRights('is_super_manager') && (this.permission.SystemReport ||
                    this.permission.support_control || this.permission.limited_support_control)) &&
                        apply('reportLinks')

            ];
        })
    )
);
