BEM.DOM.decl({ block: 'b-segment' }, {

    onSetMod: {

        js: function() {

            this.model = BEM.MODEL.getOne({
                name: this.params.modelName,
                id: this.params.modelId
            });

            this._subMan = BEM.create('i-subscription-manager');

            this._subMan.wrap(this.model)
                .on('checked', 'change', function(e, data) {
                    this.getCheckbox().getMod('focused') !== 'yes' && this.getCheckbox().setMod('checked', data.value ? 'yes' : '');
                }, this)
                .on('disabled', 'change', function(e, data) {
                    this.getCheckbox().toggleMod('disabled', 'yes', data.value);
                }, this);

        }

    },

    /**
     * Возвращает инстанс чекбокса
     * @returns {BEM}
     */
    getCheckbox: function() {
        return this._checkbox || (this._checkbox = this.findBlockInside('checkbox', 'checkbox'));
    },

    _onChecked: function(e, data) {
        this.model.set('checked', data.checked);
    },

    _getDisabledText: function() {
        return this.model.get('disabled_message');
    },

    destruct: function() {
        this._subMan.dispose();
        this._subMan.destruct();
        this.__base.apply(this, arguments);

    }

}, {

    /**
     * Показывает подсказку
     * @param {jQuery} domElem
     * @private
     */
    _showTooltip: function(domElem, text) {
        this._tipman || (this._tipman = BEM.create('tipman', {
            tipMods: { theme: 'normal' },
            popupDirections: ['right', 'bottom'],
            delay: 50
        }));

        text.length > 0 && this._tipman.show({
            owner: domElem,
            content: text
        });
    },

    /**
     * Прячет подсказку
     * @private
     */
    _hideTooltip: function() {
        this._tipman && this._tipman.hide();
    },

    live: function() {

        this.liveBindTo('checkbox', 'pointerover pointerout', function(e) {
            if (this.getCheckbox().isDisabled()) {
                e.type === 'pointerover' ?
                    this.__self._showTooltip(this.getCheckbox().domElem, this._getDisabledText()) :
                    this.__self._hideTooltip();
            }
        });

        this.liveInitOnBlockInsideEvent('change', 'checkbox', function(e, data) {
            this._onChecked(e, data)
        });

        return false;
    }

});
