BEM.DOM.decl({ block: 'b-segments-group', modName: 'type', modVal: 'audio-genres' }, {

    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            BEM.blocks['i-crypta-segments-data'].getByType('audio-genres')
                .then(function(segments) {
                    this.segments = u._.cloneDeep(segments);
                    this._initBlock();
                    this.trigger('ready');
                }.bind(this))
        }
    },

    _initBlock: function() {
        this.__base.apply(this, arguments);

        var selectedIds = this._getSelectedIds(this.params.groups);

        this.segments.forEach(function(segment) {
            selectedIds.indexOf(segment.id) !== -1 && (segment.checked = true);
            return segment;
        });

        if (this.hasMod('open', 'yes')) {
            this.renderSegments();
        }

        this.updateSelectedItemsDesc(this.segments)
            ._initEvents();
    },

    /**
     * Отрисовывает сегменты, если их нет
     */
    renderSegments: function() {

        if (!this._segmentsBlock) {

            this._segmentsBlock = BEMHTML.apply({
                block: 'b-segments-group',
                mods: { type: 'audio-genres' },
                elem: 'segments',
                segments: this.segments
            });

            this._expander.setBody(this._segmentsBlock);
            this._form = this.findBlockInside({ block: 'b-crypta-segments', modName: 'type', modVal: 'genres' });
            this._subMan.on(this._form, 'change', this._onSegmentsChanged, this)
                // при выборе аудио-группы обновляются жанры в блоке и в модели
                .on(BEM.blocks['b-edit-group-2'], 'setAudioType', this._onSegmentsAudioChanged, this);
        }
    },

    /**
     * Формирует текст свертки
     *
     * @returns {String}
     */
    getTextFromSegments: function(segments) {
        return this._getCheckedSegments(segments).map(function(segment) { return segment.name }).join(', ')
    },

    /**
     * Триггерит событие
     *
     * @param {Array<InterestsSet>} data - состояние формы
     *
     * @returns {this}
     */
    _triggerChange: function(data) {
        this.trigger('change', {
            type: 'audio-genres',
            groups: this.calculateGroups(data)
        });

        return this;
    },

    /**
     * Высчитывает формулу выбранных сегментов
     *
     * @param {Array<CryptaSegment>} segments
     *
     * @return {Array<RetConditionGroup>}
     */
    calculateGroups: function(segments) {
        return [{
            type: 'or',
            goals: this._getCheckedSegments(segments).map(function(segment) {
                return {
                    id: segment.id
                };
            })
        }]
    },

    _onSegmentsAudioChanged: function() {
        var formValue = this._form.getValue();
        this.updateSelectedItemsDesc(formValue);
        this._triggerChange(formValue);
    },

    _getCheckedSegments: function(segments) {
        return segments.filter(function(segment) {
            return segment.checked;
        });
    }
});
