BEM.DOM.decl({ block: 'b-segments-group', modName: 'type', modVal: 'behaviors' }, {

    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            BEM.blocks['i-crypta-segments-data'].getByType('behaviors')
                .then(function(segments) {
                    this.segments = u._.cloneDeep(segments);
                    this._initBlock();
                    this.trigger('ready');
                }.bind(this))
        }
    },

    _initBlock: function() {
        this.__base.apply(this, arguments);

        var selectedIds = this._getSelectedIds(this.params.groups);

        this.segments.forEach(function(segment) {
            selectedIds.indexOf(segment.id) !== -1 && (segment.checked = true);
            segment.disabled_message = iget2('b-segments-group', 'v-kategorii-ne-mogut-byt-vse-2', 'Нельзя выбрать все варианты');
            return segment;
        });

        if (this.hasMod('open', 'yes')) {
            this.renderSegments();
        }

        this.updateSelectedItemsDesc(this.segments)
            ._initEvents();
    },

    /**
     * Отрисовывает сегменты, если их нет
     */
    renderSegments: function() {

        if (!this._segmentsBlock) {

            this._segmentsBlock = BEMHTML.apply({
                block: 'b-segments-group',
                mods: { type: 'behaviors' },
                elem: 'segments',
                segments: this.segments.map(function(segment) {
                    segment.disabled_message = iget2('b-segments-group', 'v-kategorii-ne-mogut-byt-vse-2', 'Нельзя выбрать все варианты');
                    return segment;
                })
            });

            this._expander.setBody(this._segmentsBlock);
            this._form = this.findBlockInside({ block: 'b-crypta-segments', modName: 'type', modVal: 'behaviors' });
            this._subMan.on(this._form, 'change', this._onSegmentsChanged, this);

            this.restrictCheckboxes(this.segments);
        }
    },

    /**
     * Формирует текст свертки
     *
     * @param {Array<CryptaSegment>} segments - состояния сегментов формы
     *
     * @returns {String}
     */
    getTextFromSegments: function(segments) {
        return u['crypta'].calcSimpleSegmentsText(segments);
    },

    /**
     * Триггерит событие
     *
     * @param {Array<CryptaSegment>} segments - состояния сегментов формы
     *
     * @returns {this}
     */
    _triggerChange: function(segments) {
        this.trigger('change', {
            type: 'behaviors',
            groups: this.calculateGroups(segments)
        });

        return this;
    },

    /**
     * Высчитывает формулу выбранных сегментов
     *
     * @return {Array<RetConditionGroup>}
     */
    calculateGroups: function(segments) {
        return u['crypta'].calcSimpleSegmentsGroups(segments);
    }

});
