BEM.DOM.decl({ block: 'b-segments-group', modName: 'type', modVal: 'family' }, {

    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            BEM.blocks['i-crypta-segments-data'].getByType('family')
                .then(function(segments) {
                    this.segments = u._.cloneDeep(segments);
                    this._initBlock();
                    this.trigger('ready');
                }.bind(this))
        }
    },

    _initBlock: function() {
        this.__base.apply(this, arguments);

        var selectedIds = this._getSelectedIds(this.params.groups);

        this.segments = this._sortSegments(this.segments || []);

        this.segments.forEach(function(segment) {
            selectedIds.indexOf(segment.id) !== -1 && (segment.checked = true);
            segment.disabled_message = iget2('b-segments-group', 'v-kategorii-ne-mogut-byt-vse-2', 'Нельзя выбрать все варианты');
            return segment;
        });

        if (this.hasMod('open', 'yes')) {
            this.renderSegments();
        }

        this.updateSelectedItemsDesc(this.segments)
            ._initEvents();
    },

    /**
     * Отрисовывает сегменты, если их нет
     */
    renderSegments: function() {

        if (!this._segmentsBlock) {

            this._segmentsBlock = BEMHTML.apply({
                block: 'b-segments-group',
                mods: { type: 'family' },
                elem: 'segments',
                segments: this.segments.map(function(segment) {
                    segment.disabled_message = iget2('b-segments-group', 'v-kategorii-ne-mogut-byt-vse-2', 'Нельзя выбрать все варианты');
                    return segment;
                })
            });

            this._expander.setBody(this._segmentsBlock);
            this._form = this.findBlockInside({ block: 'b-crypta-segments', modName: 'type', modVal: 'family' });
            this._subMan.on(this._form, 'change', this._onSegmentsChanged, this);

            this.restrictCheckboxes(this.segments);
        }
    },

    /**
     * Формирует текст свертки
     *
     * @param {Array<CryptaSegment>} segments - состояния сегментов формы
     *
     * @returns {String}
     */
    getTextFromSegments: function(segments) {
        return u['crypta'].calcSimpleSegmentsText(segments);
    },

    /**
     * Триггерит событие
     *
     * @param {Array<CryptaSegment>} segments - состояния сегментов формы
     *
     * @returns {this}
     */
    _triggerChange: function(segments) {
        this.trigger('change', {
            type: 'family',
            groups: this.calculateGroups(segments)
        });

        return this;
    },

    /**
     * Сортирует сегменты
     * @param {Array<Object>} segments
     * @returns {*}
     * @private
     */
    _sortSegments: function(segments) {
        var splittedSegmentsByParent = segments.reduce(function(result, segment) {
            result[segment.parent_id] || (result[segment.parent_id] = []);
            result[segment.parent_id].push(segment);

            return result;
        }, {});

        (splittedSegmentsByParent[u.consts('jobsSegmentId')] || []).sort(function(a,b) {
            return a.name.localeCompare(b.name);
        });

        return Object.keys(splittedSegmentsByParent).reduce(function(res, key) {
            return res.concat(splittedSegmentsByParent[key]);
        }, []);

    },

    /**
     * Высчитывает формулу выбранных сегментов
     *
     * @return {Array<RetConditionGroup>}
     */
    calculateGroups: function(segments) {
        return u['crypta'].calcSimpleSegmentsGroups(segments);
    }

});
