BEM.DOM.decl({ block: 'b-segments-group', modName: 'type', modVal: 'interests' }, {

    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            BEM.blocks['i-crypta-segments-data'].getByType('interests')
                .then(function(segments) {
                    this.segments = segments;
                    this._initBlock();
                    this.trigger('ready');
                }.bind(this))
        }
    },

    _initBlock: function() {
        this.__base.apply(this, arguments);

        if (this.hasMod('open', 'yes')) {
            this.renderSegments();
        }

        this.updateSelectedItemsDesc(this.params.groups.map(function(group) {
            var ids = this._extractInfoFromGroup(group).ids,
                data = this.segments.filter(function(interest) {
                    return ids.indexOf(interest.id) !== -1;
                });

            return {
                preview: u['b-crypta-interests']
                    .calculatePreview(group.interest_type, data),
                selected: ids
            }
        }, this));

        this._initEvents();
    },

    /**
     * Отрисовывает сегменты, если их нет
     */
    renderSegments: function() {

        if (!this._segmentsBlock) {

            this._segmentsBlock = BEMHTML.apply({
                block: 'b-segments-group',
                mods: { type: 'interests' },
                elem: 'segments',
                segments: this.segments,
                items: this._extractInfoFromGroups(this.params.groups)
            });

            this._expander.setBody(this._segmentsBlock);
            this._form = this.findBlockInside({ block: 'b-crypta-interests-collection' });
            this._subMan.on(this._form, 'change', this._onFormChanged, this);
        }
    },

    _onFormChanged: function(e, data) {
        this.updateSelectedItemsDesc(data);
        this._triggerChange(data);
    },

    /**
     * Формирует текст свертки
     *
     * @param {Array<InterestsSet>} data - состояния сегментов формы
     *
     * @returns {String}
     */
    getTextFromSegments: function(data) {

        if (data.length === 0) { // если наборов нет - ничего не показываем
            return '';
        } else if (data.length === 1) {
            if (data[0].selected.length > 0) { // если набор 1 и не пустой то выводим интересы
                return data[0].preview
            } else { // иначе ничего
                return '';
            }
        } else {
            return iget2('b-segments-group', 'interests-summary', '{count} {text}', {
                count: data.length,
                text: u.pluralizeWord([
                    iget2('b-segments-group', 'nabor-interesov', 'набор интересов'),
                    iget2('b-segments-group', 'nabora-interesov', 'набора интересов'),
                    iget2('b-segments-group', 'naborov-interesov', 'наборов интересов'),
                    iget2('b-segments-group', 'naborov-interesov', 'наборов интересов')
                ], data.length),
                context: '2 набора интересов'
            });
        }
    },

    /**
     * Триггерит событие
     *
     * @param {Array<InterestsSet>} data - состояние формы
     *
     * @returns {this}
     */
    _triggerChange: function(data) {
        this.trigger('change', {
            type: 'interests',
            groups: this.calculateGroups(data)
        });

        return this;
    },

    /**
     * Высчитывает формулу выбранных сегментов
     *
     * @param {Array<InterestsSet>} data - состояние формы
     *
     * @return {Array<RetConditionGroup>}
     */
    calculateGroups: function(data) {

        return data.map(function(set) {

            return {
                type: 'or',
                interest_type: set.period,
                goals: set.selected.map(function(item) {
                    return {
                        id: item.id
                    }
                })
            }
        });
    },

    _extractInfoFromGroups: function(groups) {

        return groups.map(this._extractInfoFromGroup, this)
    },

    _extractInfoFromGroup: function(group) {
        return {
            period: group.interest_type,
            ids: group.goals.map(function(goal) {
                return goal.id;
            })
        }
    }

});
