BEM.DOM.decl({ block: 'b-segments-group', modName: 'type', modVal: 'metrika' }, {

    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            this._model = this._getMetrikaModel(this.params.groups);

            this._form = this._createForm(this.elem('form'), this._model);

            this._initEvents();

            this.setMod('visible', 'yes');

            this.trigger('ready');
        }
    },

    _initEvents: function() {
        this.__base.apply(this, arguments);

        this._subMan.on(this._model, 'change-data', this._onChangeModelData, this);
        this._onChangeModelData();
    },

    _onChangeModelData: function() {
        var groups = this._model.get('groupRuleCollection');
        this._updateSelectedItemsDesc(groups);
        this._triggerChange(groups);
    },

    /**
     * Триггерит событие
     *
     * @param {Array<RetargetingConditionGroupRuleDTO>} groups - состояние формы
     *
     * @returns {this}
     */
    _triggerChange: function(groups) {
        this._checkAllowToUse(groups);

        this.trigger('change', {
            type: 'metrika',
            groups: u['retargeting-condition-dto'].RetargetingConditionDTOServer(
                {
                    groupRuleCollection: groups
                }
            ).conditions
        });
    },

    /**
     * Проверяет, можно ли использовать выбранные сегменты/цели
     *
     * @param {Array<RetargetingConditionGroupRuleDTO>} groups - состояние формы
     *
     * @returns {this}
     */
    _checkAllowToUse: function(groups) {
        var forbiddenRules = this._getForbiddenRules(groups);

        this.trigger('forbid-to-use', forbiddenRules);

        return this;
    },

    _createForm: function(elem, model) {
        BEM.DOM.update(elem, BEMHTML.apply({
            block: 'b-retargeting-condition-edit',
            mods: {
                theme: 'white',
                width: 'narrow',
                type: 'groups-only'
            },
            modelName: model.name,
            modelId: model.id
        }));

        return this.findBlockInside('b-retargeting-condition-edit');
    },

    /**
     * Формирует и устанавливает значение свертки
     * @param {Array<RetargetingConditionGroupRuleDTO>} groups - группа наборов правил
     * @returns {this}
     * @private
     */
    _updateSelectedItemsDesc: function(groups) {
        var ruleCollection,
            text = '',
            forbiddenRules = this._getForbiddenRules(groups);

        if (groups.length === 1) { // если набор правил один
            ruleCollection = groups[0].ruleCollection;
            // и внутри одно выбранное правило
            if (ruleCollection.length === 1 ) {

                // и оно не пустое
                if (ruleCollection[0].goalId && ruleCollection[0].allowToUse) {
                    text = ruleCollection[0].type === 'AUDIENCE_SEGMENT' ? // у сегмента нет домена, но иногда может прилететь стандартный
                        u.escapeHTML(ruleCollection[0].name) :
                        u.escapeHTML(u._.compact([ruleCollection[0].domain, ruleCollection[0].name]).join(' :: ')); // Выводим имя

                    if (groups[0].type === 'NONE') {
                        text = iget2('b-segments-group', 'summary-not-goals-text', 'Не выполнено: {names}', {
                            names: text,
                            context: 'Не выполнено: ya.ru :: посетил сайт'
                        });
                    }

                }

            } else { // иначе кол-во правил
                text = iget2('b-segments-group', 'rules-count', '{foo} правило', {
                    some: '{foo} правила',
                    many: '{foo} правил',
                    foo: ruleCollection.length,
                    count: ruleCollection.length
                });
            }
        } else if (groups.length > 1) { // иначе выводим кол-во наборов
            text = iget2('b-segments-group', 'rules-collections-count', '{foo} набор правил', {
                some: '{foo} набора правил',
                many: '{foo} наборов правил',
                foo: groups.length,
                count: groups.length
            });
        }

        if (forbiddenRules.length) {
            text += (text ? '. ' : '') + BEMHTML.apply({
                block: 'b-segments-group',
                elem: 'error-text',
                tag: 'span',
                content: iget2('b-segments-group', 'error-rule', 'Необходимо исправить {foo} ошибку в правилах', {
                    some: 'Необходимо исправить {foo} ошибки в правилах',
                    many: 'Необходимо исправить {foo} ошибок в правилах',
                    foo: forbiddenRules.length,
                    count: forbiddenRules.length
                })
            });
        }

        this._expander.setSubtitle(text);

        return this;
    },

    /**
     * Возвращает выбранные невалидные правила
     * @param {Array<RetargetingConditionGroupRuleDTO>} groups - группа наборов правил
     * @returns {Array<RetargetingConditionRuleDTO>}
     */
    _getForbiddenRules: function(groups) {
        var rules = [];

        groups.forEach(function(group) {
            group.ruleCollection.forEach(function(rule) {
                if (!rule.allowToUse || !u['b-retargeting-condition-edit-rule'].isValidRule(rule.type, rule.day)) {
                    rules.push(rule);
                }
            });
        });

        return rules;
    },

    /**
     * Создает модель для формы редактирования условий подбора метрики
     *
     * @param {Array<RetConditionGroup>} conditions
     * @returns {b-retargeting-condition-edit}
     * @private
     */
    _getMetrikaModel: function(conditions) {
        var modelData;

        if (conditions.length) {
            modelData = u['retargeting-condition-dto'].RetargetingConditionDTO({
                id: 1,
                conditions: conditions
            });

            modelData.mode = 'edit';
        } else {
            modelData = u['retargeting-condition-dto'].RetargetingEmptyConditionDTO();
            modelData.mode = 'new';
        }

        return BEM.MODEL.create('b-retargeting-condition-edit', modelData);
    }

});
