/**
 * Обертка над формой соцдема
 *
 * @param {CryptaSegment} segments
 */
BEM.DOM.decl({ block: 'b-segments-group', modName: 'type', modVal: 'social-demo' }, {

    /**
     * Менеджер подписок
     */
    _subMan: null,

    /**
     * тут кешируется элемент содержащий форму
     */
    _segments: null,

    /**
     * Кусок аккардиона
     */
    _expander: null,

    /**
     * Форма соцдема
     */
    _form: null,

    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            this._mapping = u.consts('cryptaSocDemMapping');
            this._subtypeHash = {};

            Object.keys(this._mapping).forEach(function(key) {
                this._mapping[key].forEach(function(id) {
                    this._subtypeHash[id] = key;
                }, this);
            }, this);

            BEM.blocks['i-crypta-segments-data'].getByType('social-demo')
                .then(function(segments) {
                    this.segments = segments;
                    this._initBlock();
                    this.trigger('ready');
                }.bind(this))

        }
    },

    _initBlock: function() {
        this.__base.apply(this, arguments);

        var selectedIds = this._getSelectedIds(this.params.groups);

        this.segments.forEach(function(segment) {
            selectedIds.indexOf(segment.id) !== -1 && (segment.checked = true);
            segment.disabled_message = iget2('b-segments-group', 'v-kategorii-ne-mogut-byt-vse-2', 'Нельзя выбрать все варианты');
            return segment;
        });

        if (this.hasMod('open', 'yes')) {
            this.renderSegments();
        }

        this.updateSelectedItemsDesc(this.segments)
            ._initEvents();
    },

    /**
     * Отрисовывает сегменты, если их нет
     */
    renderSegments: function() {

        if (!this._segmentsBlock) {

            this._segmentsBlock = BEMHTML.apply({
                block: 'b-segments-group',
                mods: { type: 'social-demo' },
                elem: 'segments',
                segments: this.segments
            });

            this._expander.setBody(this._segmentsBlock);
            this._form = this.findBlockInside({ block: 'b-crypta-segments', modName: 'type', modVal: 'socdemo' });
            this._subMan.on(this._form, 'change', this._onSegmentsChanged, this);

            this.restrictCheckboxes(this.segments);
        }
    },

    /**
     * Формирует текст свертки
     *
     * @param {Array<CryptaSegment>} segments - состояния сегментов формы
     *
     * @returns {String}
     */
    getTextFromSegments: function(segments) {
        var socialDemoSummary = {
                gender: {
                    name: iget2('b-segments-group', 'pol', 'Пол'),
                    all: iget2('b-segments-group', 'lyuboy-pol', 'Любой пол')
                },
                age: {
                    name: iget2('b-segments-group', 'vozrast', 'Возраст'),
                    all: iget2('b-segments-group', 'lyuboy-vozrast', 'Любой возраст')
                },
                finance: {
                    name: iget2('b-segments-group', 'dohod', 'Доход'),
                    all: iget2('b-segments-group', 'lyuboy-dohod', 'Любой доход')
                }
            },
            subtypeHash = this._subtypeHash,
            checkedData = segments.reduce(function(result, segment) {
                var subtype = subtypeHash[segment.id];

                result[subtype] ||
                    (result[subtype] = { all: true, names: [] });

                segment.checked ?
                    result[subtype].names.push(segment.name) :
                    result[subtype].all = false;

                return result;
            }, {});

        return Object.keys(checkedData)
            .map(function(key) {
                var subTypeText = checkedData[key].names.join(', ');

                if (subTypeText) {

                    if (checkedData[key].all && socialDemoSummary[key].all) {
                        return socialDemoSummary[key].all;
                    }

                    subTypeText = socialDemoSummary[key].name + ': ' + subTypeText;
                }

                return subTypeText;
            }, this)
            .filter(function(s) { return s.length > 0 })
            .join('; ');
    },

    /**
     * Триггерит событие
     *
     * @param {Array<CryptaSegment>} segments - состояния сегментов формы
     *
     * @returns {this}
     */
    _triggerChange: function(segments) {
        this.trigger('change', {
            type: 'social-demo',
            groups: this.calculateGroups(segments)
        });

        return this;
    },

    /**
     * Высчитывает формулу выбранных сегментов
     *
     * @return {Array<RetConditionGroup>}
     */
    calculateGroups: function(segments) {
        var groups = [],
            types = {};

        segments
            .filter(function(segment) {
                return segment.checked;
            })
            .forEach(function(segment) {
                var subtype = this._subtypeHash[segment.id];

                types[subtype] || (types[subtype] = []);
                types[subtype].push(segment.id);
            }, this);

        Object.keys(types).forEach(function(key) {
            var group = { type: 'or', goals: [] };

            types[key].forEach(function(id) {
                group.goals.push({ id: id });
            });

            groups.push(group);
        });

        return groups;
    }

});
