BEM.DOM.decl({ block: 'b-segments-group' }, {

    onSetMod: {

        js: function() {
            this._subMan = BEM.create('i-subscription-manager');
            this._expander = this.findBlockInside('b-expander');
        }

    },

    _initBlock: function() {
        if (this.segments && this.segments.length) {
            this.setMod('visible', 'yes');
        }
    },

    /**
     * Подписка на события
     * @returns {this}
     * @private
     */
    _initEvents: function() {
        this._subMan
            .on(this._expander, 'open', function() {
                this.renderSegments();
            }, this);

        return this;
    },

    /**
     * Обновляет содержимое свертки
     *
     * @param {Array<CryptaSegment>} segments - состояния сегментов формы
     *
     * @returns {this}
     */
    updateSelectedItemsDesc: function(segments) {
        var text = this.getTextFromSegments(segments);

        this._expander.setSubtitle(u.escapeHTML(text));

        return this;
    },

    /**
     * Возвращает массив всех выбраных целей
     *
     * @param {Array<RetConditionGroup>} groups
     * @return {Array<RetConditionGoal.id>}
     */
    _getSelectedIds: function(groups) {
        return groups.reduce(function(result, group) {
            group.goals.forEach(function(goal) {
                result.push(goal.id);
            });

            return result;
        }, []);
    },

    /**
     * Обработчик изменения поля сегменты в модели
     * @private
     */
    _onSegmentsChanged: function(e) {
        var formValue = e.block.getValue();
        this.updateSelectedItemsDesc(formValue);
        this.restrictCheckboxes(formValue);
        this._triggerChange(formValue);
    },

    /**
     * Запрещает выбирать последний нечекнутый сегмент среди своей группы
     *
     * @param {Array<CryptaSegment>} segments - состояния сегментов формы
     *
     * @returns {BEM}
     */
    restrictCheckboxes: function(segments) {
        // выбираем группы, в которых есть ограничение на выбор сегментов
        var restrictGroups = segments.reduce(function(groups, segment) {
            if (segment.parent_id || segment.can_select_all) {
                return groups;
            }

            groups[segment.id] = {
                checked: [],
                unchecked: []
            };
            return groups;
        }, {}, this);

        // сортируем сегменты по checked/unchecked
        segments.forEach(function(segment) {
            if (restrictGroups[segment.parent_id]) {
                segment.checked ?
                    restrictGroups[segment.parent_id].checked.push(segment.id) :
                    restrictGroups[segment.parent_id].unchecked.push(segment.id);
            }
        }, this);

        // если в группе остался последний сегмент -- дизейблим его
        // иначе раздизейбливаем оставшиеся нечекнутые
        u._.keys(restrictGroups).forEach(function(id) {

            var uncheckedModels = restrictGroups[id].unchecked;

            if (uncheckedModels.length === 1) {
                this._form.setDisable(uncheckedModels, true);
            } else {
                this._form.setDisable(uncheckedModels, false);
            }
        }, this);

        return this;
    },

    destruct: function() {
        this._subMan.dispose();
        this._subMan.destruct();

        this.__base.apply(this, arguments);
    }

});
