BEM.DOM.decl({ block: 'b-select-filter', modName: 'group-limit' }, {

    onSetMod: {
        js: function() {
            this.__base();

            this._groupLimit = this.getMod('group-limit');
            this._checkGroupsLimit();
        }
    },

    /**
     * Вызывается после смены значения
     * @private
     */
    _onAfterChange: function() {
        this._checkGroupsLimit();
    },

    /**
     * Проверяет ограничения по группам
     * @private
     */
    _checkGroupsLimit: function() {
        var selected = this.getSelected(),
            options = this.params.options,
            selectedGroups = u._.uniq(selected.map(u._.property('group')));

        selectedGroups.length >= this._groupLimit ?
            this._disableUnselectedGroups(options, selectedGroups) :
            this.enableAllItems();

        // DIRECT-65328: возвращается 500 если выбрать столбец «Процент полученных показов (%)»
        // временно отключаем winrate
        if (u._.find(options, { value: 'winrate' })) {
            this.disableItems(['winrate']);
        }
    },

    /**
     * Выключает все варианты, которые отсутствуют в выбранных группах
     *
     * @param {Array<Option>} options - все варианты
     * @param {Array<Option.value>} selectedGroups - группы в которых есть выбранные варианты
     * @private
     */
    _disableUnselectedGroups: function(options, selectedGroups) {
        options.forEach(function(option) {
            selectedGroups.indexOf(option.group) === -1 &&
                this.disableItems([option.value])
        }, this);
    },

    /**
     * Вызывается при наведении мышки на элемент списка
     * @param {Event} e
     * @private
     */
    _onItemMouseOver: function(e) {
        var selectItemName = this.getMod(e.data.domElem, 'name'),
            filtersItems = this._chooser.getAll(),
            filterItem = u._.find(filtersItems, { name: selectItemName }),
            message = u._.get(this.params, 'messages.filter-item.group-limit');

        // DIRECT-65328: возвращается 500 если выбрать столбец «Процент полученных показов (%)»
        // временно отключаем winrate
        if (selectItemName === 'winrate') {
            message = u._.get(this.params, 'messages.filter-item.winrate-disabled');
        }

        filterItem.disabled && message && this._showTooltip(e.data.domElem, message);
    },

    /**
     * Вызывается когда курсор мыши покидает элемент списка
     * @private
     */
    _onItemMouseOut: function() {
        this._hideTooltip();
    }

});
