/**
 * @typedef Option
 * @type {Object}
 * @property {String} text - текст для отображения
 * @property {String} value - значение
 * @property {String} [group] - группа (для использования с `group-limit`
 */

/**
 * @typedef {Object} Message
 * @property {Object} [switcher] - сообщения для отображения возле контрола
 * @property {Object} [switcher.disabled] - сообщение для состояния disabled
 * @property {Object} [filter-item] - сообщения для отображения возле варианта
 * @property {Object} [filter-item.group-limit] - сообщение для состояния disabled при моде group-limit
 */

/**
 * block: b-select-filter
 *
 * @param {String} [text] - текст контрола
 * @param {Array<Option>} options - варианты выбора
 * @param {Message} [messages] - предупреждающие сообщения
 */
block('b-select-filter')(

    js()(function() {
        return {
            text: this.ctx.text,
            options: this.ctx.options,
            messages: this.ctx.messages || null,
            hellipCut: this.ctx.hellipCut || null
        }
    }),

    elem('switcher-name')(
        tag()('span')
    ),

    elem('switcher-selected-options')(
        tag()('span')
    ),

    content()(function() {
        var chooserContent = [],
            selectedDefault = [],
            ctx = this.ctx;

        ctx.options.forEach(function(option) {
            chooserContent.push({
                elem: 'item',
                mix: {
                    block: 'b-select-filter',
                    elem: 'filter-item',
                    elemMods: { name: u.beminize(option.value) }
                },
                elemMods: {
                    selected: option.selected,
                    disabled: option.disabled
                },
                js: option,
                content: option.text,
                name: option.value
            });

            option.selected == 'yes' && selectedDefault.push(option.value);
        });

        if (ctx.clear && chooserContent.length > 0) {
            chooserContent = chooserContent.concat([
                {
                    elem: 'separator'
                },
                {
                    elem: 'unselect-all',
                    label: ctx.clear.text
                }
            ])
        }

        return {
            block: 'dropdown2',
            mix: { block: 'b-select-filter', elem: 'dropdown' },
            mods: {
                switcher: 'button',
                theme: 'normal',
                'has-tick': 'yes',
                size: 's',
                disabled: this.mods.disabled
            },
            switcher: {
                block: 'button',
                mix: { block: 'b-select-filter', elem: 'switcher' },
                content: [
                    ctx.text && [{
                        block: 'b-select-filter',
                        elem: 'switcher-name',
                        content: ctx.text
                    }, ': '],
                    {
                        block: 'b-select-filter',
                        elem: 'switcher-selected-options',
                        content: u['b-select-filter'].getSwitcherOptionsText(
                            ctx.options,
                            selectedDefault,
                            ctx.hellipCut
                        )
                    }
                ]
            },
            popup: {
                block: 'popup2',
                directions: ['bottom-left'],
                mix: {
                    block: 'b-select-filter',
                    elem: 'popup',
                    elemMods: { height: this.mods.height }
                },
                content: {
                    block: 'b-chooser',
                    mix: [
                        { block: 'b-select-filter', elem: 'chooser' },

                    ],
                    mods: {
                        multi: this.mods.multi,
                        'allow-empty': 'yes'
                    },
                    content: {
                        elem: 'wrap',
                        mix: [
                            { block: 'b-select-filter', elem: 'wrap' },
                            { block: 'i-wheel-prevent', js: true }
                        ],
                        content: chooserContent
                    }
                }
            }
        }
    })
);
