BEM.DOM.decl('b-select-filter', {

    onSetMod: {
        js: function() {

            u.graspSelf.call(this, {
                _chooser: 'b-chooser on chooser',
                _dropdown: 'dropdown2 on dropdown'
            });

            this._initEvents();
        },

        disabled: function(mod, val) {
            this._dropdown.setMod('disabled', val);
        },

        multi: function(mod, val) {
            this._chooser.setMod('multi', val);
        },

        'group-limit': function(modName, modVal) {
            this._groupLimit = modVal;
        }
    },

    _initEvents: function() {
        this._subscriptionManager = BEM.create('i-subscription-manager')
            .on(this._chooser, 'change', this._onChange, this)
            .on(this.getPopup(), 'beforeOpen', this._beforeOpenPopup, this)
            .on(this.getPopup(), 'beforeClose', this._beforeClosePopup, this);
    },

    /**
     * Вызывется перед тем как открывается попап
     * @private
     */
    _beforeOpenPopup: function() {
        this.bindTo('filter-item', 'mouseover', this._onItemMouseOver)
            .bindTo('filter-item', 'mouseout', this._onItemMouseOut);
    },

    /**
     * Вызывется перед тем как закрывается попап
     * @private
     */
    _beforeClosePopup: function() {
        this._hideTooltip();
        this.unbindFrom('filter-item', 'mouseover')
            .unbindFrom('filter-item', 'mouseout');
    },

    /**
     * Вызывается при смене значения
     * @param {Event} e
     * @param {Object} data
     * @private
     */
    _onChange: function(e, data) {
        var selected = this.getSelected(),
            newSwitcherText;

        if (data.selected || this._chooser.hasMod('allow-empty') && !selected.length) {
            newSwitcherText = u['b-select-filter']
                .getSwitcherOptionsText(
                    this.params.options,
                    selected.map(u._.property('value')),
                    this.params.hellipCut
                );

            this._setSwitcherOptionsText(newSwitcherText);
            this.trigger('change', selected);
        }

        this._onAfterChange(e, data);
    },

    /**
     * Вызывается после смены значения
     * @private
     */
    _onAfterChange: function(e, data) {

    },

    /**
     * Показывает тултип с сообщением у заданного элемента
     * @param {BEM} owner
     * @param {String} text
     * @private
     */
    _showTooltip: function(owner, text) {
        var content;

        content = BEMHTML.apply({
            block: 'b-select-filter',
            elem: 'tooltip',
            content: text
        });

        this._getTooltip()
            .setContent(content)
            .setOwner(owner)
            .setMod('shown', 'yes');
    },

    /**
     * Возвращает инстанс tooltip для отображения сообщений
     * @returns {BEM}
     * @private
     */
    _getTooltip: function() {
        return this.tooltip ||
            (this.tooltip = $(BEMHTML.apply({
                block: 'tooltip',
                mods: {
                    size: 'xs',
                    type: 'direct',
                    theme: 'normal'
                }
            }))
            .bem('tooltip'));
    },

    /**
     * Скрывает попап с ошибками фразы
     * @private
     */
    _hideTooltip: function() {
        this._getTooltip()
            .delMod('shown');
    },

    /**
     * Показывает сообщение, при наведении на кнопку
     * @param {Event} e
     *
     * @private
     */
    _showDropdownHoverMessage: function(e) {
        // тут в данный момент не используется, переопределен в модификаторе
    },

    /**
     * Прячет сообщение, когда курсор покидает кнопку
     * @param {Event} e
     *
     * @private
     */
    _hideDropdownHoverMessage: function(e) {
        // тут в данный момент не используется, переопределен в модификаторе
    },

    /**
     * Вызывается при наведении мышки на элемент списка
     * @param {Event} e
     *
     * @private
     */
    _onItemMouseOver: function(e) {

    },

    /**
     * Вызывается когда курсор мыши покидает элемент списка
     * @param {Event} e
     *
     * @private
     */
    _onItemMouseOut: function(e) {

    },

    /**
     * Добавляет в кнопку инфорацию о выбранных вариантах
     *
     * @param {String} optionsText - текстовое представление выбранных вариантов
     * @private
     */
    _setSwitcherOptionsText: function(optionsText) {
        this.elem('switcher-selected-options')
            .text(optionsText);
    },

    /**
     * Возвращает все варианты
     * @return {{text, name, value, selected, hidden, [group], extraParams, disabled}}
     */
    getAll: function() {
        return this._chooser.getAll();
    },

    /**
     * Возвращает выбранные варианты
     * @return {Array} [{text, name, value, selected, hidden, [group], extraParams, disabled}]
     */
    getSelected: function() {
        var selected = [],
            chooserSelected = this._chooser.getSelected();

        chooserSelected && selected.push(chooserSelected);

        return selected;
    },

    /**
     * Делает выбранными переданные значения (остальные будут unchecked)
     * @param {Array<Option.value>} selected - массив значение
     */
    setSelected: function(selected) {
        var currentSelected = this.getSelected().map(u._.property('value'));

        currentSelected.forEach(function(option) { // выключаем ненужные
            selected.indexOf(option) == -1 && this._chooser.uncheck(option);
        }, this);
        selected.forEach(function(option) { // включаем нужные
            currentSelected.indexOf(option) == -1 && this._chooser.check(option);
        }, this);
    },

    /**
     * Выставляет disabled вариантам
     * @param {Array<Option.value>} values - поле value варианта
     */
    disableItems: function(values) {
        values.forEach(function(value) {
            this._chooser.disable(u.beminize(value));
        }, this);
    },

    /**
     * Выставляет disabled всем вариантам
     */
    disableAllItems: function() {
        this.params.options.forEach(function(option) {
            this.disableItems([option.value]);
        }, this)
    },

    /**
     * Убирает disabled вариантам
     * @param {Array<Option.value>} values - поле value варианта
     */
    enableItems: function(values) {
        values.forEach(function(value) {
            this._chooser.enable(u.beminize(value));
        }, this);
    },

    /**
     * Убирает disabled всем вариантам
     */
    enableAllItems: function() {
        this.params.options.forEach(function(option) {
            this.enableItems([option.value]);
        }, this)
    },

    /**
     * Возвращает экземпляр кнопки
     * @return {BEM}
     */
    getSwitcher: function() {
        return this._dropdown.getSwitcher();
    },

    /**
     * Устанавливает имя фильтра
     *
     * @param {String} name - имя фильтра
     * @private
     */
    setSwitcherName: function(name) {
        this.elem('switcher-name')
            .text(name);
    },

    /**
     * Возвращает экземпляр попапа
     * @return {BEM}
     */
    getPopup: function() {
        return this._dropdown.getPopup();
    },

    destruct: function() {
        this._subscriptionManager.dispose();
        this._getTooltip().destruct();
        this._dropdown.getPopup().destruct();
        this._dropdown.destruct();
        this.__base.apply(this, arguments);
    }
}, {
    live: function() {
        this
            .liveBindTo('dropdown', 'mouseover', function(e) {
                this._showDropdownHoverMessage(e);

            })
            .liveBindTo('dropdown', 'mouseout', function(e) {
                this._hideDropdownHoverMessage(e);
            })
            .liveInitOnBlockInsideEvent('init', 'dropdown2');
    }
});
