u.register({
    'b-select-filter': {

        /**
         * Подготавливает текст для кнопки
         *
         * @param {Array<Option>} options - опции фильтра
         * @param {Array<Option.value>} selectedOptions - выбранные опции
         * @param {Number} [hellipCut] - количество символов в тексте опций
         *
         * @return {String} - button text
         */
        getSwitcherOptionsText: function(options, selectedOptions, hellipCut) {
            var text,
                selectedOptionsNames = options
                    .reduce(function(prev, option) {
                        selectedOptions.indexOf(option.value) >= 0 && prev.push(option.text);

                        return prev;
                    },[]);

            if (selectedOptionsNames.length > 0) {
                text = selectedOptionsNames.join(', ');
                hellipCut && (text = u.hellipCut(text, hellipCut, '...'))
            } else {
                text = iget2('b-select-filter', 'ne-vybran', 'не выбран');
            }

            return text;
        }

    }
});
