/**
 * @param {String} this.params.key ключ обрабатываемого элемента
 * @param {Object} [this.params.data] параметры элемента
 */
BEM.DOM.decl({ block: 'b-selectable-control', modName: 'type', modVal: 'checkbox' }, {
    onSetMod: {
        js: function() {
            this._checkbox = this.findBlockOn(this.domElem, 'checkbox');

            this._checkbox.on('change', function(e, data) {
                this._notifySelected({
                    key: this.params.key,
                    isSelected: data.checked
                });
            }, this);
        }
    },

    /**
     * @override {b-selectable-control}
     */
    _isSelected: function(key) {
        return this._checkbox.isChecked();
    },

    /**
     * @override {b-selectable-control}
     */
    _setSelected: function(key, value) {
        this._checkbox.setMod('checked', value ? 'yes' : '');
    },

    /**
     * @override {b-selectable-control}
     */
    _getHandledKeys: function() {
        return [this.params.key];
    },

    /**
     * @override {b-selectable-control}
     */
    _getData: function(key) {
        return this.params.data;
    }
});
