/**
 * @param {Object} this.params.items обрабатываемые элементы, ключи объекта - ключи элемента, значения - данные элементов
 */
BEM.DOM.decl({ block: 'b-selectable-control', modName: 'type', modVal: 'radiobox' }, {
    onSetMod: {
        js: function() {
            this._radiobox = this.findBlockOn(this.domElem, 'radiobox');

            this._radiobox.on('change', function(e, data) {
                if (data.prev.length) {
                    this._notifySelected({
                        key: this._getRadioVal(data.prev),
                        isSelected: false
                    });
                }
                this._notifySelected({
                    key: this._getRadioVal(data.current),
                    isSelected: true
                });
            }, this);
        }
    },

    /**
     * Возвращает значение указанного элемента радио из радиобокса
     * @param {jQuery} node
     * @returns {String}
     */
    _getRadioVal: function(node) {
        return this._radiobox.findElem(node, 'control').val();
    },

    /**
     * @override {b-selectable-control}
     */
    _isSelected: function(key) {
        return this._radiobox.val() == key;
    },

    /**
     * @override {b-selectable-control}
     */
    _setSelected: function(key, value) {
        value && this._radiobox.val(value);
    },

    /**
     * @override {b-selectable-control}
     */
    _getHandledKeys: function(items) {
        if (items !== undefined) {
            this.params.items = u._.extend(this.params.items, items);
        }

        return Object.keys(this.params.items);
    },

    /**
     * @override {b-selectable-control}
     */
    _getData: function(key) {
        return this.params.items[key];
    }
});
