/*
 * @fires i-selectable#selectedChanged
*/
BEM.DOM.decl('b-selectable-control', {
    /**
     * Возвращает массив ключей, которые может обрабатывать
     * @protected
     * @returns {String[]}
     */
    _getHandledKeys: function() {
        throw new Error('must be implemented by subclass');
    },

    /**
     * Говорит, выбран ли контрол указанного элемента
     * @protected
     * @param {String} key ключ интересующего элемента
     * @return {Boolean}
     */
    _isSelected: function(key) {
        throw new Error('must be implemented by subclass');
    },

    /**
     * Возвращает данные элемента по ключу
     * @protected
     * @param {String} key ключ интересующего элемента
     * @returns {*}
     */
    _getData: function(key) {
        throw new Error('must be implemented by subclass');
    },

    /**
     * Устанавливает контрол в состояние выбранности для указанного элемента
     * @protected
     * @param {String} key ключ элемента
     * @param {Boolean} value состояние выбранности
     */
    _setSelected: function(key, value) {
        throw new Error('must be implemented by subclass');
    },

    /**
     * Уведомляем i-selectable о смене выбранности элемента
     * @protected
     * @param {selectedChangeData} data данные об изменении
     * @fires i-selectable#selectedChanged
     */
    _notifySelected: function(data) {
        this.trigger('selectedChanged', {
            source: this,
            data: data
        });
    }
});
