block('b-selector-switch')(

    content()(function() {
        return [
            this.ctx.title ?
                {
                    elem: 'title',
                    content: this.ctx.title
                } :
                '',
            {
                block: 'select',
                mods: {
                    size: this.mods.size ? this.mods.size : 's',
                    theme: this.mods.theme ? this.mods.theme : 'normal'
                },
                content: [
                    {
                        block: 'button',
                        mods: {
                            size: 's',
                            theme: 'normal'
                        },
                        content: this.ctx.optionsList[this.ctx.currentOption]
                    },
                    {
                        elem: 'control',
                        content: apply('buildOptions')
                    }
                ]
            }
        ];
    }),

    mode('buildOptions')(function() {
        var ctx = this.ctx,
            optionsList = ctx.optionsList,
            currentOptionName = ctx.currentOption,
            optionsNames = Object.keys(optionsList);

        return optionsNames.map(function(optionName) {
            var is_current = currentOptionName == optionName,
                attrs = {
                    value: optionName
                };

            is_current && (attrs.selected = 'selected');

            return {
                elem: 'option',
                attrs: attrs,
                mix: [{
                    block: 'b-selector-switch',
                    elem: 'item'
                }],
                elemMods: {
                    state: is_current ? 'current' : ''
                },
                content: optionsList[optionName]
            };
        });
    })
);
