/**
 *
 * @event b-selector-switch#focus так же, как у блока select
 * @event b-selector-switch#blur  так же, как у блока select
 * @event b-selector-switch#change так же, как у блока select
 *
 * @fires b-selector-switch#focus
 * @fires b-selector-switch#blur
 * @fires b-selector-switch#change
 */
BEM.DOM.decl('b-selector-switch', {

    onSetMod: {
        js: function() {
            this._initEvents();
        }
    },

    /**
     * Инициация фильтрации по типам кампаний при инициации страницы
     */
    initDefault: function() {
        this.trigger('change', this.findBlockInside('select').val());
    },

    /**
     * Удаляет блок и подписки i-subscription-manager
     * @override
     */
    destruct: function() {
        this._subscriptionManager.dispose();
        this.__base();
    },

    /**
     * Подписка на события (focus, blur, select) блока select
     * Проксирование событий внутреннего блока select вверх
     * @private
     */
    _initEvents: function() {
        this._subscriptionManager = BEM.create('i-subscription-manager');
        this._subscriptionManager
            .wrap(this.findBlockInside('select'))
            .on('focus', function() { this.trigger('focus'); }, this)
            .on('blur', function() { this.trigger('blur'); }, this)
            .on('change', function(e) {
                this.trigger('change', e.block.val());
            }, this);
    }
}, {
    live: function() {
        this.liveInitOnBlockInsideEvent('change', 'select');
    }
});
