block('b-show-user-emails')(
    content()(function() {
        var user = this.ctx.user,
            showServicingForCamp = function(camp) {
                return camp.ManagerUID;
            },
            showServicing = this.ctx.camps.some(showServicingForCamp);

        return [
            {
                elem: 'header',
                content: iget2('b-show-user-emails', 'adresa-el-pochty-dlya', 'Адреса эл. почты для уведомлений')
            },
            {
                elem: 'emails-info',
                content: [
                    {
                        elem: 'emails-info-header',
                        content: iget2('b-show-user-emails', 'polzovatel', 'Пользователь')
                    },
                    {
                        elem: 'emails-info-row',
                        label: iget2('b-show-user-emails', 'fio', 'ФИО:'),
                        value: u.escapeHTML(user.fio)
                    },
                    {
                        elem: 'emails-info-row',
                        label: 'email:',
                        value: u.escapeHTML(user.email)
                    },
                    {
                        elem: 'emails-info-row',
                        label: iget2('b-show-user-emails', 'posylat-novosti', 'посылать новости:'),
                        value: {
                            elem: 'tick',
                            value: user.sendNews
                        }
                    },
                    {
                        elem: 'emails-info-row',
                        label: iget2('b-show-user-emails', 'posylat-preduprezhdeniya', 'посылать предупреждения:'),
                        value: {
                            elem: 'tick',
                            value: user.sendWarn
                        }
                    },
                    showServicing && {
                        elem: 'emails-info-row',
                        label: iget2('b-show-user-emails', 'posylat-bezzabotnye-uvedomleniya', 'посылать "беззаботные" уведомления:'),
                        value: {
                            elem: 'tick',
                            value: user.sendAccNews
                        }
                    }
                ]
            },
            {
                elem: 'emails-table',
                content: [
                    {
                        elem: 'emails-table-title',
                        content: iget2('b-show-user-emails', 'po-vsem-kampaniyam', 'По всем кампаниям') + ':'
                    },
                    {
                        elem: 'emails-table-row',
                        elemMods: {
                            header: 'yes'
                        },
                        content: [
                            {
                                elem: 'emails-table-cell',
                                content: '&#8470;'
                            },
                            {
                                elem: 'emails-table-cell',
                                content: iget2('b-show-user-emails', 'kampaniya', 'кампания')
                            },
                            {
                                elem: 'emails-table-cell',
                                content: iget2('b-show-user-emails', 'fio-100', 'ФИО')
                            },
                            {
                                elem: 'emails-table-cell',
                                content: 'email'
                            },
                            {
                                elem: 'emails-table-cell',
                                content: iget2('b-show-user-emails', 'preduprezhdeniya', 'предупреждения')
                            },
                            showServicing && {
                                elem: 'emails-table-cell',
                                content: iget2('b-show-user-emails', 'bezzabotnye', 'беззаботные')
                            }
                        ]
                    },
                    this.ctx.camps.map(function(camp) {
                        return {
                            elem: 'emails-table-row',
                            content: [
                                {
                                    elem: 'emails-table-cell',
                                    content: camp.cid
                                },
                                {
                                    elem: 'emails-table-cell',
                                    content: '"' + u.escapeHTML(camp.name) + '"'
                                },
                                {
                                    elem: 'emails-table-cell',
                                    content: u.escapeHTML(camp.FIO || user.fio)
                                },
                                {
                                    elem: 'emails-table-cell',
                                    content: u.escapeHTML(camp.email || user.email)
                                },
                                {
                                    elem: 'emails-table-cell',
                                    elemMods: {
                                        content: 'tick'
                                    },
                                    content: {
                                        elem: 'tick',
                                        value: camp.sendWarn || user.sendWarn
                                    }
                                },
                                showServicingForCamp(camp) && {
                                    elem: 'emails-table-cell',
                                    elemMods: {
                                        content: 'tick'
                                    },
                                    content: {
                                        elem: 'tick',
                                        value: camp.sendAccNews || user.sendAccNews
                                    }
                                }
                            ]
                        }
                    })
                ]
            }
        ];
    }),

    elem('emails-info').tag()('table'),
    elem('emails-info-header')(
        tag()('tr'),
        content()(function() {
            return {
                tag: 'td',
                content: {
                    tag: 'h2',
                    content: this.ctx.content
                }
            };
        })
    ),

    elem('emails-info-row')(
        tag()('tr'),
        content()(function() {
            return [
                {
                    elem: 'label',
                    tag: 'td',
                    content: this.ctx.label
                },
                {
                    elem: 'value',
                    tag: 'td',
                    content: this.ctx.value
                }
            ];
        })
    ),

    elem('emails-table').tag()('table'),

    elem('emails-table-title').tag()('caption'),

    elem('emails-table-row').tag()('tr'),

    elem('emails-table-cell').tag()('td'),

    elem('tick')(
        tag()('span'),
        content()('&mdash;')
    ),

    elem('tick').match(function() { return (this.ctx.value === 'Yes' || this.ctx.value === 2); })(
        content()(function() {
            return {
                block: 'b-icon',
                mods: {
                    'size-13': 'tick-black'
                }
            };
        })
    )
);
