block('b-showclients-list').elem('table').replace()(function() {
    var data = this.data,
        listParams = this.listParams || {},
        mix = [
            {
                block: 'b-style-table',
                mods: {
                    theme: 'gray-list'
                }
            },
            {
                block: 'b-showclients-list',
                elem: 'table',
                elemMods: listParams.isEmptyOfflineSearch ? { visibility: 'hidden' } : ''
            }
        ],
        formSort = data.FORM.sort && u.escapeHTML(data.FORM.sort) || listParams.defaultSort;

    listParams.massAction && mix.push({
        block: 'b-checkboxes-group',
        js: true,
        mods: {
            ignored: 'yes'
        }
    });

    return {
        block: 'b-data-table',
        mods: {
            sortable: 'server',
            'has-num-column': 'yes'
        },
        mix: mix,
        numColTitle: '№',
        mixes: this.tableMixes,
        jsParams: listParams.search ?
            function(clients) {
                var result = [],
                    isPaginationEnabled = listParams.isPaginationEnabled,
                    getSearchIndex = function(client) {
                        var searchIndex = [];

                        ['login', 'FIO', 'phone', 'email', 'clientid', 'agency_name']
                            .forEach(function(i) {
                                return client[i] && searchIndex.push(client[i]);
                            });

                        return searchIndex.join('\n').toLowerCase();
                    };

                clients.forEach(function(client, index) {
                    var repsSearchIndex = '';

                    isPaginationEnabled && client.client_reps && client.client_reps.forEach(function(rep) {
                        repsSearchIndex += getSearchIndex(rep);
                    });

                    result.push({
                        searchIndex: isPaginationEnabled ? '' : getSearchIndex(client),
                        desc: client.description || '',
                        login: client.login,
                        repsSearchIndex: repsSearchIndex || ''
                    });
                });

                return {
                    rows: result
                };
            } : true,
        disabledReverse: true,
        disabledSort: true,
        columns: this.columns,
        rows: this.rows,
        startIndex: this.startIndex || ((data.page || 1) - 1) * (data.per_page || 0),
        sortBy: formSort || ((this.pageParams || {}).isAgencySearch ? 'ClientID' : 'login'),
        rowTransform: function(res, row) {
            // убираем последнюю ячейку для строки представителя
            if (row.isChild) res.pop();

            return res;
        }
    };
});
